/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoTypeHelper;
import org.nuxeo.ecm.core.opencmis.impl.util.ListUtils;
import org.nuxeo.ecm.core.opencmis.impl.util.SimpleImageInfo;

public class NuxeoObjectData
implements ObjectData {
    public static final String STREAM_ICON = "nx:icon";
    public NuxeoCmisService service;
    public DocumentModel doc;
    public boolean creation = false;
    private List<String> propertyIds;
    private Boolean includeAllowableActions;
    private IncludeRelationships includeRelationships;
    private String renditionFilter;
    private Boolean includePolicyIds;
    private Boolean includeAcl;
    private static final BindingsObjectFactory objectFactory = new BindingsObjectFactoryImpl();
    private TypeDefinition type;
    private static final int CACHE_MAX_SIZE = 10;
    private static final int DEFAULT_MAX_RENDITIONS = 20;
    private Map<String, Properties> propertiesCache = new HashMap<String, Properties>();
    private CallContext callContext;
    private static final String STAR = "*";
    protected static final List<String> STAR_FILTER = Collections.singletonList("*");

    public NuxeoObjectData(NuxeoCmisService service, DocumentModel doc, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.service = service;
        this.doc = doc;
        this.propertyIds = NuxeoObjectData.getPropertyIdsFromFilter(filter);
        this.includeAllowableActions = includeAllowableActions;
        this.includeRelationships = includeRelationships;
        this.renditionFilter = renditionFilter;
        this.includePolicyIds = includePolicyIds;
        this.includeAcl = includeAcl;
        this.type = service.repository.getTypeDefinition(NuxeoTypeHelper.mappedId(doc.getType()));
        this.callContext = service.callContext;
    }

    protected NuxeoObjectData(NuxeoCmisService service, DocumentModel doc) {
        this(service, doc, null, null, null, null, null, null, null);
    }

    public NuxeoObjectData(NuxeoCmisService service, DocumentModel doc, OperationContext context) {
        this(service, doc, context.getFilterString(), context.isIncludeAllowableActions(), context.getIncludeRelationships(), context.getRenditionFilterString(), context.isIncludePolicies(), context.isIncludeAcls(), null);
    }

    protected static List<String> getPropertyIdsFromFilter(String filter) {
        if (filter == null || filter.length() == 0) {
            return STAR_FILTER;
        }
        List<String> ids = Arrays.asList(filter.split(",\\s*"));
        if (ids.contains(STAR)) {
            ids = STAR_FILTER;
        }
        return ids;
    }

    public String getId() {
        return this.doc.getId();
    }

    public BaseTypeId getBaseTypeId() {
        return NuxeoTypeHelper.getBaseTypeId(this.doc);
    }

    public TypeDefinition getTypeDefinition() {
        return this.type;
    }

    public Properties getProperties() {
        return this.getProperties(this.propertyIds);
    }

    protected Properties getProperties(List<String> propertyIds) {
        String key = StringUtils.join(propertyIds, (char)',');
        Properties properties = this.propertiesCache.get(key);
        if (properties == null) {
            Map propertyDefinitions = this.type.getPropertyDefinitions();
            int len = propertyIds == STAR_FILTER ? propertyDefinitions.size() : propertyIds.size();
            ArrayList props = new ArrayList(len);
            for (PropertyDefinition pd : propertyDefinitions.values()) {
                if (propertyIds != STAR_FILTER && !propertyIds.contains(pd.getId())) continue;
                props.add(NuxeoPropertyData.construct(this, pd, this.callContext));
            }
            properties = objectFactory.createPropertiesData(props);
            this.limitCacheSize();
            this.propertiesCache.put(key, properties);
        }
        return properties;
    }

    protected void limitCacheSize() {
        if (this.propertiesCache.size() >= 10) {
            Properties sf = this.propertiesCache.get(STAR);
            this.propertiesCache.clear();
            if (sf != null) {
                this.propertiesCache.put(STAR, sf);
            }
        }
    }

    public NuxeoPropertyDataBase<?> getProperty(String id) {
        return (NuxeoPropertyDataBase)this.getProperties(STAR_FILTER).getProperties().get(id);
    }

    public AllowableActions getAllowableActions() {
        if (!Boolean.TRUE.equals(this.includeAllowableActions)) {
            return null;
        }
        return NuxeoObjectData.getAllowableActions(this.doc, this.creation);
    }

    public static AllowableActions getAllowableActions(DocumentModel doc, boolean creation) {
        boolean canWrite;
        BaseTypeId baseType = NuxeoTypeHelper.getBaseTypeId(doc);
        boolean isDocument = baseType == BaseTypeId.CMIS_DOCUMENT;
        boolean isFolder = baseType == BaseTypeId.CMIS_FOLDER;
        boolean isRoot = "/".equals(doc.getPathAsString());
        try {
            canWrite = creation || doc.getCoreSession().hasPermission(doc.getRef(), "Write");
        }
        catch (ClientException e) {
            canWrite = false;
        }
        EnumSet<Action> set = EnumSet.noneOf(Action.class);
        set.add(Action.CAN_GET_OBJECT_PARENTS);
        set.add(Action.CAN_GET_PROPERTIES);
        if (isFolder) {
            set.add(Action.CAN_GET_DESCENDANTS);
            set.add(Action.CAN_GET_FOLDER_TREE);
            set.add(Action.CAN_GET_CHILDREN);
            if (!isRoot) {
                set.add(Action.CAN_GET_FOLDER_PARENT);
            }
        } else if (isDocument) {
            set.add(Action.CAN_GET_CONTENT_STREAM);
            set.add(Action.CAN_GET_ALL_VERSIONS);
            set.add(Action.CAN_ADD_OBJECT_TO_FOLDER);
            set.add(Action.CAN_REMOVE_OBJECT_FROM_FOLDER);
            try {
                if (doc.isCheckedOut()) {
                    set.add(Action.CAN_CHECK_IN);
                    set.add(Action.CAN_CANCEL_CHECK_OUT);
                } else {
                    set.add(Action.CAN_CHECK_OUT);
                }
            }
            catch (ClientException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        if (isFolder || isDocument) {
            set.add(Action.CAN_GET_RENDITIONS);
        }
        if (canWrite) {
            if (isFolder) {
                set.add(Action.CAN_CREATE_DOCUMENT);
                set.add(Action.CAN_CREATE_FOLDER);
                set.add(Action.CAN_CREATE_RELATIONSHIP);
                set.add(Action.CAN_DELETE_TREE);
            } else if (isDocument) {
                set.add(Action.CAN_SET_CONTENT_STREAM);
                set.add(Action.CAN_DELETE_CONTENT_STREAM);
            }
            set.add(Action.CAN_UPDATE_PROPERTIES);
            if (isFolder || isDocument) {
                set.add(Action.CAN_MOVE_OBJECT);
            }
            if (!isRoot) {
                set.add(Action.CAN_DELETE_OBJECT);
            }
        }
        if (Boolean.FALSE.booleanValue()) {
            set.add(Action.CAN_GET_OBJECT_RELATIONSHIPS);
            set.add(Action.CAN_APPLY_POLICY);
            set.add(Action.CAN_REMOVE_POLICY);
            set.add(Action.CAN_GET_APPLIED_POLICIES);
            set.add(Action.CAN_GET_ACL);
            set.add(Action.CAN_APPLY_ACL);
        }
        AllowableActionsImpl aa = new AllowableActionsImpl();
        aa.setAllowableActions(set);
        return aa;
    }

    public List<RenditionData> getRenditions() {
        if (this.renditionFilter == null || this.renditionFilter.length() == 0) {
            return null;
        }
        return NuxeoObjectData.getRenditions(this.doc, null, null, this.callContext);
    }

    public static List<RenditionData> getRenditions(DocumentModel doc, BigInteger maxItems, BigInteger skipCount, CallContext callContext) {
        try {
            String iconPath;
            ArrayList<RenditionData> list = new ArrayList();
            try {
                iconPath = (String)((Object)doc.getPropertyValue("common:icon"));
            }
            catch (PropertyException e) {
                iconPath = null;
            }
            InputStream is = NuxeoObjectData.getIconStream(iconPath, callContext);
            if (is != null) {
                RenditionDataImpl ren = new RenditionDataImpl();
                ren.setStreamId(STREAM_ICON);
                ren.setKind("cmis:thumbnail");
                int slash = iconPath.lastIndexOf(47);
                String filename = slash == -1 ? iconPath : iconPath.substring(slash + 1);
                ren.setTitle(filename);
                SimpleImageInfo info = new SimpleImageInfo(is);
                ren.setBigLength(BigInteger.valueOf(info.getLength()));
                ren.setBigWidth(BigInteger.valueOf(info.getWidth()));
                ren.setBigHeight(BigInteger.valueOf(info.getHeight()));
                ren.setMimeType(info.getMimeType());
                list.add((RenditionData)ren);
            }
            list = ListUtils.batchList(list, maxItems, skipCount, 20);
            return list;
        }
        catch (IOException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public static InputStream getIconStream(String iconPath, CallContext context) throws ClientException {
        ServletContext servletContext;
        if (iconPath == null || iconPath.length() == 0) {
            return null;
        }
        if (!iconPath.startsWith("/")) {
            iconPath = '/' + iconPath;
        }
        if ((servletContext = (ServletContext)context.get("servletContext")) == null) {
            throw new CmisRuntimeException("Cannot get servlet context");
        }
        return servletContext.getResourceAsStream(iconPath);
    }

    public List<ObjectData> getRelationships() {
        return NuxeoObjectData.getRelationships(this.getId(), this.includeRelationships, this.doc.getCoreSession(), this.service);
    }

    public static List<ObjectData> getRelationships(String id, IncludeRelationships includeRelationships, CoreSession coreSession, NuxeoCmisService service) {
        if (includeRelationships == null || includeRelationships == IncludeRelationships.NONE) {
            return null;
        }
        String statement = "SELECT cmis:objectId, cmis:baseTypeId, cmis:sourceId, cmis:targetId FROM " + BaseTypeId.CMIS_RELATIONSHIP.value() + " WHERE ";
        String qid = "'" + id.replace("'", "''") + "'";
        if (includeRelationships != IncludeRelationships.TARGET) {
            statement = statement + "cmis:sourceId = " + qid;
        }
        if (includeRelationships == IncludeRelationships.BOTH) {
            statement = statement + " OR ";
        }
        if (includeRelationships != IncludeRelationships.SOURCE) {
            statement = statement + "cmis:targetId = " + qid;
        }
        ArrayList<ObjectData> list = new ArrayList<ObjectData>();
        IterableQueryResult res = null;
        try {
            HashMap typeInfo = new HashMap();
            res = coreSession.queryAndFetch(statement, "CMISQL", new Object[]{service, typeInfo});
            for (Map map : res) {
                list.add((ObjectData)service.makeObjectData(map, typeInfo));
            }
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (res != null) {
                res.close();
            }
        }
        return list;
    }

    public Acl getAcl() {
        if (!Boolean.TRUE.equals(this.includeAcl)) {
            return null;
        }
        AccessControlListImpl acl = new AccessControlListImpl();
        ArrayList aces = new ArrayList();
        acl.setAces(aces);
        return acl;
    }

    public Boolean isExactAcl() {
        return Boolean.FALSE;
    }

    public PolicyIdList getPolicyIds() {
        if (!Boolean.TRUE.equals(this.includePolicyIds)) {
            return null;
        }
        return new PolicyIdListImpl();
    }

    public ChangeEventInfo getChangeEventInfo() {
        return null;
    }

    public List<CmisExtensionElement> getExtensions() {
        return Collections.emptyList();
    }

    public void setExtensions(List<CmisExtensionElement> extensions) {
    }
}

