/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.DocWriter;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.jboss.seam.pdf.ITextUtils;
import org.jboss.seam.pdf.KeyStoreConfig;
import org.jboss.seam.pdf.ui.ITextComponent;
import org.jboss.seam.pdf.ui.UIDocument;
import org.jboss.seam.util.FacesResources;
import org.jboss.seam.util.Resources;

public class UISignature
extends ITextComponent {
    String field;
    String size;
    String reason;
    String location;

    public void setField(String field) {
        this.field = field;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void createITextObject(FacesContext context) {
    }

    public void removeITextObject() {
    }

    public Object getITextObject() {
        return null;
    }

    public void handleAdd(Object other) {
        throw new RuntimeException("PDF signature does not accept children");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        PdfWriter writer = this.findWriter();
        if (writer == null) {
            throw new RuntimeException("Cannot find PdfWriter - the document may not exist or may not be a pdf type");
        }
        PdfAcroForm form = writer.getAcroForm();
        this.field = (String)this.valueBinding(context, "field", this.field);
        if (this.field == null) {
            throw new RuntimeException("signature field named is required");
        }
        this.size = (String)this.valueBinding(context, "size", this.size);
        if (this.size == null) {
            throw new RuntimeException("signature size is required");
        }
        float[] rect = ITextUtils.stringToFloatArray(this.size);
        if (rect.length != 4) {
            throw new RuntimeException("size must contain four numbers");
        }
        form.addSignature(this.field, rect[0], rect[1], rect[2], rect[3]);
        UIDocument doc = (UIDocument)this.findITextParent((UIComponent)this, UIDocument.class);
        doc.addSignature(this);
        super.encodeEnd(context);
    }

    private PdfWriter findWriter() {
        DocWriter writer;
        UIDocument doc = (UIDocument)this.findITextParent((UIComponent)this, UIDocument.class);
        if (doc != null && (writer = doc.getWriter()) instanceof PdfWriter) {
            return (PdfWriter)writer;
        }
        return null;
    }

    public byte[] sign(byte[] originalBytes) {
        byte[] byArray;
        KeyStoreConfig store = KeyStoreConfig.instance();
        InputStream is = null;
        try {
            is = FacesResources.getResourceAsStream((String)store.getKeyStore(), (ExternalContext)this.getFacesContext().getExternalContext());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(is, store.getKeyStorePassword().toCharArray());
            PrivateKey key = (PrivateKey)ks.getKey(store.getKeyAlias(), store.getKeyPassword().toCharArray());
            Certificate[] chain = ks.getCertificateChain(store.getKeyAlias());
            PdfReader reader = new PdfReader(originalBytes);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PdfStamper stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)os, (char)'\u0000');
            PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
            appearance.setCrypto(key, chain, null, PdfSignatureAppearance.SELF_SIGNED);
            appearance.setReason(this.reason);
            appearance.setLocation(this.location);
            appearance.setVisibleSignature(this.field);
            stamper.close();
            byArray = os.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Resources.closeStream(is);
                throw throwable;
            }
        }
        Resources.closeStream((InputStream)is);
        return byArray;
    }
}

