/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateWrapper {
    protected final Calendar date;

    public DateWrapper() {
        this.date = Calendar.getInstance();
    }

    public DateWrapper(Calendar date) {
        this.date = date;
    }

    public DateWrapper(Date date) {
        this.date = Calendar.getInstance();
        this.date.setTime(date);
    }

    public DateWrapper(long date) {
        this.date = Calendar.getInstance();
        this.date.setTimeInMillis(date);
    }

    public DateWrapper months(int months) {
        this.date.add(2, months);
        return this;
    }

    public DateWrapper days(int days) {
        this.date.add(5, days);
        return this;
    }

    public DateWrapper years(int years) {
        this.date.add(1, years);
        return this;
    }

    public DateWrapper seconds(int seconds) {
        this.date.add(13, seconds);
        return this;
    }

    public DateWrapper weeks(int weeks) {
        this.date.add(4, weeks);
        return this;
    }

    public Calendar getCalendar() {
        return this.date;
    }

    public Date getDate() {
        return this.date.getTime();
    }

    public long getTime() {
        return this.date.getTimeInMillis();
    }

    public int getYear() {
        return this.date.get(1);
    }

    public int getMonth() {
        return this.date.get(2);
    }

    public int getDay() {
        return this.date.get(5);
    }

    public int getMinute() {
        return this.date.get(12);
    }

    public int getHour() {
        return this.date.get(10);
    }

    public int getSecond() {
        return this.date.get(13);
    }

    public int getWeek() {
        return this.date.get(3);
    }

    public String format(String format) {
        return new SimpleDateFormat(format).format(this.date.getTime());
    }

    public String toString() {
        return this.toQueryString();
    }

    public String toQueryString() {
        return new SimpleDateFormat("'TIMESTAMP' ''yyyy-MM-dd HH:mm:ss.SSS''").format(this.getDate());
    }

    public static void main(String[] args) {
        DateWrapper d = new DateWrapper();
        System.out.println(d);
        d.months(2);
        System.out.println(d);
        d.months(-2);
        System.out.println(d);
        d.months(-2);
        System.out.println(d);
        d.months(-1);
        System.out.println(d);
        d.years(-2);
        System.out.println(d);
        d.years(4);
        System.out.println(d);
        d.weeks(2);
        System.out.println(d);
        d.weeks(-1);
        System.out.println(d);
    }
}

