/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.rendering;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.rendering.Renderer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.resource.ResourceService;

public class MvelRender
implements Renderer {
    protected Map<String, CompiledTemplate> cache = Collections.synchronizedMap(new Cache());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(String uriOrContent, Map<String, Object> root) throws Exception {
        CompiledTemplate compiled = null;
        String content = null;
        if (uriOrContent.startsWith("template:")) {
            String name = uriOrContent.substring("template:".length());
            compiled = this.cache.get(name);
            if (compiled == null) {
                URL url = ((ResourceService)Framework.getService(ResourceService.class)).getResource(name);
                if (url == null) {
                    throw new OperationException("Rendering resource not found: " + name);
                }
                InputStream in = url.openStream();
                try {
                    content = FileUtils.read((InputStream)in);
                }
                finally {
                    in.close();
                }
                compiled = TemplateCompiler.compileTemplate((String)content);
                this.cache.put(name, compiled);
            }
        } else {
            content = uriOrContent;
            compiled = TemplateCompiler.compileTemplate((String)content);
        }
        Object obj = TemplateRuntime.execute((CompiledTemplate)compiled, root);
        return obj == null ? "" : obj.toString();
    }

    private static class Cache
    extends LinkedHashMap<String, CompiledTemplate> {
        protected int maxCachedItems;

        private Cache() {
            this(128);
        }

        private Cache(int maxCachedItems) {
            super(maxCachedItems, 1.0f, true);
            this.maxCachedItems = maxCachedItems;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CompiledTemplate> eldest) {
            return this.size() > this.maxCachedItems;
        }
    }
}

