/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.io.Serializable;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;

@Operation(id="Document.SetProperty", category="Document", label="Update Property", description="Set a single property value on the input document. The property is specified using its xpath. The document is automatically saved if 'save' parameter is true. If you unset the 'save' you need to save it later using Save Document operation. Return the modified document.")
public class SetDocumentProperty {
    public static final String ID = "Document.SetProperty";
    @Context
    protected CoreSession session;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="value")
    protected Serializable value;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        Property p = doc.getProperty(this.xpath);
        Type type = p.getField().getType();
        if (!type.isSimpleType()) {
            throw new OperationException("Only scalar types can be set using update operation");
        }
        if (this.value.getClass() == String.class) {
            p.setValue(((SimpleType)type).getPrimitiveType().decode((String)((Object)this.value)));
        } else {
            p.setValue((Object)this.value);
        }
        if (this.save) {
            doc = this.session.saveDocument(doc);
        }
        return doc;
    }
}

