/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.Collection;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.FetchByProperty", category="Fetch", label="Fetch By Property", description="For each specified string property value, fetch all documents that match the property and the optional where clause. Matching documents are collected into a list and the returned to the next operation. The operation has no input.")
public class FetchByProperty {
    public static final String ID = "Document.FetchByProperty";
    @Context
    protected CoreSession session;
    @Param(name="property", required=true)
    protected String property;
    @Param(name="values", required=true)
    protected StringList values;
    @Param(name="query", required=false)
    protected String query;

    @OperationMethod
    public DocumentModelList run() throws Exception {
        if (this.query != null && this.query.trim().length() == 0) {
            this.query = null;
        }
        String queryWhereClause = "SELECT * FROM Document WHERE %s=\"%s\" AND (%s)";
        String queryNoWhereClause = "SELECT * FROM Document WHERE %s=\"%s\"";
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (String value : this.values) {
            String q = this.query != null ? String.format(queryWhereClause, this.property, value, this.query) : String.format(queryNoWhereClause, this.property, value);
            DocumentModelList docs = this.session.query(q);
            result.addAll((Collection)docs);
        }
        return result;
    }
}

