/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor.views;

import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.html.filters.layout.DefaultLayoutView;
import org.nuxeo.theme.rendering.RenderingInfo;

public class SectionLayout
extends DefaultLayoutView {
    static final String[] SIZER_PROPERTIES = new String[]{"width", "margin-left", "margin-right"};

    public String render(RenderingInfo info) {
        Format layout = info.getFormat();
        StringBuilder sizerStyle = new StringBuilder();
        for (String property : SIZER_PROPERTIES) {
            String value = layout.getProperty(property);
            if (value == null) continue;
            sizerStyle.append(String.format("%s: %s;", property, value));
        }
        String width = layout.getProperty("width");
        if (width == null) {
            width = "";
        }
        String sectionId = info.getElement().getUid().toString();
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"nxthemesSectionLayout\">");
        html.append("<form style=\"").append(sizerStyle.toString()).append("\" class=\"nxthemesSizer\" action=\"\" onsubmit=\"return false\">").append("<b class=\"left\"></b><b class=\"right\"></b>").append("<input class=\"nxthemesInput\" type=\"text\" size=\"5\"").append(" value=\"").append(width).append("\" name=\"width\" />").append("<input type=\"hidden\" name=\"id\" value=\"").append(layout.getUid().toString()).append("\" /></form>");
        html.append(super.render(info));
        html.append("<table class=\"nxthemesAlignSection\"><tr>");
        html.append("<td><div class=\"nxthemesAlignSectionLeft\" title=\"Left\" sectionid=\"").append(sectionId).append("\"></div></td>");
        html.append("<td><div class=\"nxthemesAlignSectionCenter\" title=\"Center\" sectionid=\"").append(sectionId).append("\" ></div></td>");
        html.append("<td><div class=\"nxthemesAlignSectionRight\" title=\"Right\" sectionid=\"").append(sectionId).append("\" ></div></td>");
        html.append("</tr></table>");
        html.append("<a href=\"javascript:void(0)\" class=\"nxthemesAddSection\" title=\"Add a section\"><div sectionid=\"").append(sectionId).append("\" > Add a section</div></a>");
        html.append("</div>");
        return html.toString();
    }
}

