/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NoInitialContextException;
import org.apache.log4j.Logger;
import org.nuxeo.common.Environment;
import org.nuxeo.common.jndi.NamingContextFactory;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.ra.PoolingRepositoryFactory;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.TransactionalConfig;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deploy(value={"org.nuxeo.runtime.jtajca"})
@RepositoryConfig(cleanup=Granularity.METHOD, repositoryFactoryClass=PoolingRepositoryFactory.class)
public class TransactionalFeature
extends SimpleFeature {
    protected TransactionalConfig config;
    protected boolean txStarted;
    protected Class<? extends RepositoryFactory> defaultFactory;

    public void initialize(FeaturesRunner runner) throws Exception {
        this.config = (TransactionalConfig)runner.getDescription().getAnnotation(TransactionalConfig.class);
        if (this.config == null) {
            this.config = (TransactionalConfig)Defaults.of(TransactionalConfig.class);
        }
    }

    public void start(FeaturesRunner runner) throws Exception {
        Environment env = Environment.getDefault();
        if (env != null) {
            env.setHostApplicationName("NXServer");
        }
        try {
            Context comp = (Context)new InitialContext().lookup("java:comp/");
            if (comp == null) {
                NamingContextFactory.setAsInitial();
            }
        }
        catch (NoInitialContextException e) {
            NamingContextFactory.setAsInitial();
        }
        NuxeoContainer.install();
    }

    public void beforeSetup(FeaturesRunner runner) throws Exception {
        if (!this.config.autoStart()) {
            return;
        }
        this.txStarted = TransactionHelper.startTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTeardown(FeaturesRunner runner) throws Exception {
        if (!this.txStarted) {
            if (TransactionHelper.isTransactionActive()) {
                try {
                    TransactionHelper.setTransactionRollbackOnly();
                    TransactionHelper.commitOrRollbackTransaction();
                }
                finally {
                    Logger.getLogger(TransactionalFeature.class).warn((Object)"Committing a transaction for your, please do it yourself");
                }
            }
            return;
        }
        TransactionHelper.commitOrRollbackTransaction();
    }
}

