/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.local.LocalSession;
import org.nuxeo.ecm.core.model.Repository;

public class TestRepositoryHandler {
    private Repository repository;
    private final String repositoryName;

    public TestRepositoryHandler(String name) {
        this.repositoryName = name;
    }

    public void openRepository() throws Exception {
        this.repository = NXCore.getRepositoryService().getRepositoryManager().getRepository(this.repositoryName);
    }

    public CoreSession openSessionAs(String userName) throws ClientException {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("username", userName);
        CoreSession session = LocalSession.createInstance();
        session.connect(this.repositoryName, ctx);
        return session;
    }

    public CoreSession openSession(Map<String, Serializable> ctx) throws ClientException {
        if (ctx == null) {
            throw new IllegalArgumentException("The session context cannot be null");
        }
        CoreSession session = LocalSession.createInstance();
        session.connect(this.repositoryName, ctx);
        return session;
    }

    public void releaseRepository() {
        if (this.repository != null) {
            this.repository.shutdown();
        }
    }

    public void releaseSession(CoreSession session) {
        CoreInstance.getInstance().close(session);
    }
}

