/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import com.google.inject.Scope;
import java.io.Serializable;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.test.CoreScope;
import org.nuxeo.ecm.core.test.TestRepositoryHandler;
import org.nuxeo.ecm.core.test.annotations.BackendType;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.model.persistence.fs.ContributionLocation;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.ServiceProvider;

public class RepositorySettings
extends ServiceProvider<CoreSession> {
    private static final Log log = LogFactory.getLog(RepositorySettings.class);
    protected FeaturesRunner runner;
    protected BackendType type;
    protected String repositoryName;
    protected String databaseName;
    protected String username;
    protected RepositoryInit repoInitializer;
    protected Granularity granularity;
    protected Class<? extends RepositoryFactory> repositoryFactoryClass;
    protected TestRepositoryHandler repo;
    protected CoreSession session;
    private Map<String, Serializable> sessionContext;

    protected RepositorySettings() {
        super(CoreSession.class);
        this.importAnnotations((RepositoryConfig)Defaults.of(RepositoryConfig.class));
    }

    protected RepositorySettings(RepositoryConfig config) {
        super(CoreSession.class);
        this.importAnnotations(config);
    }

    protected RepositorySettings(FeaturesRunner runner, RepositoryConfig config) {
        super(CoreSession.class);
        this.runner = runner;
        this.importAnnotations(config);
    }

    public RepositorySettings(FeaturesRunner runner) {
        super(CoreSession.class);
        this.runner = runner;
        RepositoryConfig conf = (RepositoryConfig)runner.getConfig(RepositoryConfig.class);
        if (conf == null) {
            conf = (RepositoryConfig)Defaults.of(RepositoryConfig.class);
        }
        this.importAnnotations(conf);
    }

    public void importAnnotations(RepositoryConfig repo) {
        this.type = repo.type();
        this.repositoryName = repo.repositoryName();
        this.databaseName = repo.databaseName();
        this.username = repo.user();
        this.granularity = repo.cleanup();
        this.repositoryFactoryClass = repo.repositoryFactoryClass();
        this.repoInitializer = this.newInstance(repo.init());
    }

    protected <T> T newInstance(Class<? extends T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new Error("Cannot instanciate " + clazz.getSimpleName(), e);
        }
    }

    public void importSettings(RepositorySettings settings) {
        this.shutdown();
        RepositoryConfig defaultConfig = (RepositoryConfig)Defaults.of(RepositoryConfig.class);
        if (defaultConfig.type() != settings.type) {
            this.type = settings.type;
        }
        this.username = settings.username;
        this.repositoryName = settings.repositoryName;
        this.databaseName = settings.databaseName;
    }

    public BackendType getBackendType() {
        return this.type;
    }

    public void setBackendType(BackendType type) {
        this.type = type;
    }

    public String getName() {
        return this.repositoryName;
    }

    public void setName(String name) {
        this.repositoryName = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public RepositoryInit getInitializer() {
        return this.repoInitializer;
    }

    public void setInitializer(RepositoryInit initializer) {
        this.repoInitializer = initializer;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public void setGranularity(Granularity granularity) {
        this.granularity = granularity;
    }

    public void initialize() {
        DatabaseHelper dbHelper = DatabaseHelper.DATABASE;
        try {
            RuntimeHarness harness = ((RuntimeFeature)this.runner.getFeature(RuntimeFeature.class)).getHarness();
            log.info((Object)"Deploying a VCS repo implementation");
            dbHelper.setRepositoryName(this.repositoryName);
            dbHelper.setUp(this.repositoryFactoryClass);
            OSGiAdapter osgi = harness.getOSGiAdapter();
            BundleImpl bundle = osgi.getRegistry().getBundle("org.nuxeo.ecm.core.storage.sql.test");
            String contribPath = dbHelper.getDeploymentContrib();
            URL contribURL = bundle.getEntry(contribPath);
            Assert.assertNotNull((String)("deployment contrib " + contribPath + " not found"), (Object)contribURL);
            ContributionLocation contrib = new ContributionLocation(this.repositoryName, contribURL);
            harness.getContext().deploy((StreamRef)contrib);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            if (this.repo != null) {
                if (this.session != null) {
                    this.releaseSession();
                }
                this.repo.releaseRepository();
                this.repo = null;
            }
        }
        finally {
            try {
                DatabaseHelper.DATABASE.tearDown();
            }
            catch (SQLException e) {
                throw new Error("Cannot release database", e);
            }
        }
    }

    public TestRepositoryHandler getRepositoryHandler() {
        if (this.repo == null) {
            try {
                this.repo = new TestRepositoryHandler(this.repositoryName);
                this.repo.openRepository();
            }
            catch (Exception e) {
                log.error((Object)e.toString(), (Throwable)e);
                return null;
            }
        }
        return this.repo;
    }

    public CoreSession createSession() {
        assert (this.session == null);
        try {
            this.session = this.openSessionAs(this.getUsername());
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        return this.session;
    }

    public void releaseSession() {
        assert (this.session != null);
        this.repo.releaseSession(this.session);
        this.session = null;
    }

    public CoreSession getSession() {
        return this.session;
    }

    public CoreSession openSessionAs(String userName) throws ClientException {
        this.sessionContext = new Hashtable<String, Serializable>();
        this.sessionContext.put("username", (Serializable)((Object)userName));
        return this.getRepositoryHandler().openSession(this.sessionContext);
    }

    public CoreSession openSessionAsAdminUser(String username) throws ClientException {
        return this.openSessionAs(username, true, false);
    }

    public CoreSession openSessionAsAnonymousUser(String username) throws ClientException {
        return this.openSessionAs(username, false, true);
    }

    public CoreSession openSessionAsSystemUser() throws ClientException {
        return this.openSessionAs("system", true, false);
    }

    public CoreSession openSessionAs(String username, boolean isAdmin, boolean isAnonymous) throws ClientException {
        ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
        if (this.sessionContext == null) {
            throw new IllegalStateException("session was not yet opened!");
        }
        UserPrincipal principal = new UserPrincipal(username, new ArrayList(), isAnonymous, isAdmin);
        this.sessionContext.put("username", (Serializable)((Object)username));
        this.sessionContext.put("principal", (Serializable)principal);
        return this.getRepositoryHandler().openSession(this.sessionContext);
    }

    public CoreSession get() {
        return this.getSession();
    }

    public Scope getScope() {
        return CoreScope.INSTANCE;
    }
}

