/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.RepositorySettings;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfigs;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

public class MultiNuxeoCoreRunner
extends ParentRunner<FeaturesRunner> {
    private final List<FeaturesRunner> runners = new ArrayList<FeaturesRunner>();
    private RepositorySettings[] configs;

    public MultiNuxeoCoreRunner(Class<?> testClass, RunnerBuilder builder) throws InitializationError {
        this(builder, testClass, MultiNuxeoCoreRunner.getSuiteClasses(testClass), MultiNuxeoCoreRunner.getRepositorySettings(testClass));
    }

    public MultiNuxeoCoreRunner(RunnerBuilder builder, Class<?> testClass, Class<?>[] classes, RepositorySettings[] repoTypes) throws InitializationError {
        this(null, builder.runners(null, (Class[])classes), repoTypes);
    }

    protected MultiNuxeoCoreRunner(Class<?> klass, List<Runner> runners, RepositorySettings[] configs) throws InitializationError {
        super(klass);
        for (Runner runner : runners) {
            this.runners.add((FeaturesRunner)runner);
        }
        this.configs = configs;
    }

    protected String getName() {
        return "Nuxeo Core Suite: " + ((Object)((Object)this)).getClass();
    }

    protected static RepositorySettings[] getRepositorySettings(Class<?> testClass) {
        RepositoryConfigs annotation = testClass.getAnnotation(RepositoryConfigs.class);
        if (annotation == null) {
            return new RepositorySettings[]{new RepositorySettings()};
        }
        RepositoryConfig[] annos = annotation.value();
        RepositorySettings[] result = new RepositorySettings[annos.length];
        for (int i = 0; i < annos.length; ++i) {
            result[i] = new RepositorySettings(annos[i]);
        }
        return result;
    }

    protected static Class<?>[] getSuiteClasses(Class<?> klass) throws InitializationError {
        Suite.SuiteClasses annotation = klass.getAnnotation(Suite.SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", klass.getName()));
        }
        return annotation.value();
    }

    protected Description describeChild(FeaturesRunner child) {
        return child.getDescription();
    }

    protected List<FeaturesRunner> getChildren() {
        return this.runners;
    }

    protected void runChild(FeaturesRunner child, RunNotifier notifier) {
        for (RepositorySettings config : this.configs) {
            CoreFeature cf = (CoreFeature)child.getFeature(CoreFeature.class);
            if (cf != null) {
                cf.setRepositorySettings(config);
            }
            child.run(notifier);
        }
    }
}

