/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.Map;

public class CoreScope
implements Scope {
    protected final ThreadLocal<Map<Key<?>, Object>> values = new ThreadLocal<Map<Key<?>, Object>>(){

        @Override
        protected Map<Key<?>, Object> initialValue() {
            return new HashMap();
        }
    };
    public static final CoreScope INSTANCE = new CoreScope();

    protected CoreScope() {
    }

    public void enter() {
        this.values.get();
    }

    public void exit() {
        this.values.remove();
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                Map scopedMap = CoreScope.this.getScopedObjectMap(key);
                Object current = scopedMap.get(key);
                if (current == null && !scopedMap.containsKey(key)) {
                    current = unscoped.get();
                    scopedMap.put(key, current);
                }
                return current;
            }
        };
    }

    private <T> Map<Key<?>, Object> getScopedObjectMap(Key<T> key) {
        Map<Key<?>, Object> scopedObjects = this.values.get();
        if (scopedObjects == null) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
        }
        return scopedObjects;
    }
}

