/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.test;

import com.google.inject.Binder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.test.CoreScope;
import org.nuxeo.ecm.core.test.RepositorySettings;
import org.nuxeo.ecm.core.test.annotations.BackendType;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryInit;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.ServiceProvider;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Deploy(value={"org.nuxeo.ecm.core.schema", "org.nuxeo.ecm.core.query", "org.nuxeo.ecm.core.api", "org.nuxeo.ecm.core.event", "org.nuxeo.ecm.core", "org.nuxeo.ecm.core.convert", "org.nuxeo.ecm.core.convert.plugins", "org.nuxeo.ecm.core.storage.sql", "org.nuxeo.ecm.core.storage.sql.test"})
@Features(value={RuntimeFeature.class})
public class CoreFeature
extends SimpleFeature {
    private static final Log log = LogFactory.getLog(CoreFeature.class);
    protected int initialOpenSessions;
    protected RepositorySettings repository;

    public RepositorySettings getRepository() {
        return this.repository;
    }

    public BackendType getBackendType() {
        return this.repository.getBackendType();
    }

    public void initialize(FeaturesRunner runner) throws Exception {
        this.repository = new RepositorySettings(runner);
        ((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).addServiceProvider((ServiceProvider)this.repository);
    }

    public void start(FeaturesRunner runner) throws Exception {
        this.repository.initialize();
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(RepositorySettings.class).toInstance((Object)this.repository);
    }

    public void beforeRun(FeaturesRunner runner) throws Exception {
        this.initialOpenSessions = CoreInstance.getInstance().getNumberOfSessions();
        if (this.repository.getGranularity() != Granularity.METHOD) {
            this.initializeSession(runner);
        }
    }

    public void afterRun(FeaturesRunner runner) throws Exception {
        if (this.repository.getGranularity() != Granularity.METHOD) {
            this.cleanupSession(runner);
        }
        this.repository.shutdown();
        CoreInstance core = CoreInstance.getInstance();
        int finalOpenSessions = core.getNumberOfSessions();
        int leakedOpenSessions = finalOpenSessions - this.initialOpenSessions;
        if (leakedOpenSessions != 0) {
            log.error((Object)String.format("There are %s open session(s) at tear down; it seems the test leaked %s session(s).", finalOpenSessions, leakedOpenSessions));
            for (CoreInstance.RegistrationInfo info : core.getRegistrationInfos()) {
                log.warn((Object)"Leaking session", (Throwable)info);
            }
        }
    }

    public void beforeSetup(FeaturesRunner runner) throws Exception {
        if (this.repository.getGranularity() == Granularity.METHOD) {
            this.initializeSession(runner);
        }
    }

    public void afterTeardown(FeaturesRunner runner) throws Exception {
        if (this.repository.getGranularity() == Granularity.METHOD) {
            this.cleanupSession(runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupSession(FeaturesRunner runner) {
        CoreSession session = (CoreSession)runner.getInjector().getInstance(CoreSession.class);
        try {
            ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
            session.removeChildren((DocumentRef)new PathRef("/"));
            session.save();
            ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
        }
        catch (ClientException e) {
            log.error((Object)"Unable to reset repository", (Throwable)e);
        }
        finally {
            CoreScope.INSTANCE.exit();
        }
        this.repository.releaseSession();
    }

    protected void initializeSession(FeaturesRunner runner) {
        CoreScope.INSTANCE.enter();
        CoreSession session = this.repository.createSession();
        RepositoryInit factory = this.repository.getInitializer();
        if (factory != null) {
            try {
                factory.populate(session);
                session.save();
                ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
            }
            catch (ClientException e) {
                log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    public void setRepositorySettings(RepositorySettings settings) {
        this.repository.importSettings(settings);
    }
}

