/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.javascript;

import com.sun.script.javascript.RhinoScriptEngine;
import com.sun.script.util.ScriptEngineFactoryBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoScriptEngineFactory
extends ScriptEngineFactoryBase {
    private static List<String> names = new ArrayList<String>(6);
    private static List<String> mimeTypes;
    private static List<String> extensions;

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return "javascript";
        }
        if (key.equals("javax.script.engine")) {
            return "Mozilla Rhino";
        }
        if (key.equals("javax.script.engine_version")) {
            return "1.6 release 2";
        }
        if (key.equals("javax.script.language")) {
            return "ECMAScript";
        }
        if (key.equals("javax.script.language_version")) {
            return "1.6";
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        RhinoScriptEngine ret = new RhinoScriptEngine();
        ret.setEngineFactory(this);
        return ret;
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        String ret = obj + "." + method + "(";
        int len = args.length;
        if (len == 0) {
            ret = ret + ")";
            return ret;
        }
        for (int i = 0; i < len; ++i) {
            ret = ret + args[i];
            ret = i != len - 1 ? ret + "," : ret + ")";
        }
        return ret;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuffer buf = new StringBuffer();
        int len = toDisplay.length();
        buf.append("print(\"");
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\")");
        return buf.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        int len = statements.length;
        String ret = "";
        for (int i = 0; i < len; ++i) {
            ret = ret + statements[i] + ";";
        }
        return ret;
    }

    public static void main(String[] args) {
        RhinoScriptEngineFactory fact = new RhinoScriptEngineFactory();
        System.out.println(fact.getParameter("javax.script.engine_version"));
    }

    static {
        names.add("js");
        names.add("rhino");
        names.add("JavaScript");
        names.add("javascript");
        names.add("ECMAScript");
        names.add("ecmascript");
        names = Collections.unmodifiableList(names);
        mimeTypes = new ArrayList<String>(4);
        mimeTypes.add("application/javascript");
        mimeTypes.add("application/ecmascript");
        mimeTypes.add("text/javascript");
        mimeTypes.add("text/ecmascript");
        mimeTypes = Collections.unmodifiableList(mimeTypes);
        extensions = new ArrayList<String>(1);
        extensions.add("js");
        extensions = Collections.unmodifiableList(extensions);
    }
}

