/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.jmock.core.CoreMock;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class DefaultResultStub
implements Stub {
    private Map resultValuesByType = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultResultStub() {
        this.createDefaultResults();
    }

    public StringBuffer describeTo(StringBuffer buf) {
        return buf.append("returns a default value");
    }

    public void addResult(Class resultType, Object resultValue) {
        this.resultValuesByType.put(resultType, resultValue);
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Class<?> returnType = invocation.invokedMethod.getReturnType();
        if (this.resultValuesByType.containsKey(returnType)) {
            return this.resultValuesByType.get(returnType);
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        if (returnType.isInterface()) {
            CoreMock nullMock = new CoreMock(returnType, "null" + Formatting.classShortName(returnType));
            nullMock.setDefaultStub(this);
            return nullMock.proxy();
        }
        throw new AssertionFailedError(this.createErrorMessage(invocation));
    }

    public String createErrorMessage(Invocation call) {
        StringBuffer buf = new StringBuffer();
        buf.append("unexpected result type: ");
        buf.append(call.invokedMethod.getReturnType().toString());
        buf.append("\n");
        if (this.resultValuesByType.isEmpty()) {
            buf.append("no result types are registered!");
        } else {
            buf.append("expected one of: ");
            Iterator i = this.resultValuesByType.keySet().iterator();
            boolean separatorRequired = false;
            while (i.hasNext()) {
                if (separatorRequired) {
                    buf.append(", ");
                }
                buf.append(((Class)i.next()).getName());
                separatorRequired = true;
            }
        }
        return buf.toString();
    }

    protected void createDefaultResults() {
        this.addResult(Boolean.TYPE, Boolean.FALSE);
        this.addResult(Void.TYPE, null);
        this.addResult(Byte.TYPE, new Byte(0));
        this.addResult(Short.TYPE, new Short(0));
        this.addResult(Integer.TYPE, new Integer(0));
        this.addResult(Long.TYPE, new Long(0L));
        this.addResult(Character.TYPE, new Character('\u0000'));
        this.addResult(Float.TYPE, new Float(0.0f));
        this.addResult(Double.TYPE, new Double(0.0));
        this.addResult(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultResultStub.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.FALSE);
        this.addResult(class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultResultStub.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(0));
        this.addResult(class$java$lang$Short == null ? (class$java$lang$Short = DefaultResultStub.class$("java.lang.Short")) : class$java$lang$Short, new Short(0));
        this.addResult(class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultResultStub.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(0));
        this.addResult(class$java$lang$Long == null ? (class$java$lang$Long = DefaultResultStub.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        this.addResult(class$java$lang$Character == null ? (class$java$lang$Character = DefaultResultStub.class$("java.lang.Character")) : class$java$lang$Character, new Character('\u0000'));
        this.addResult(class$java$lang$Float == null ? (class$java$lang$Float = DefaultResultStub.class$("java.lang.Float")) : class$java$lang$Float, new Float(0.0f));
        this.addResult(class$java$lang$Double == null ? (class$java$lang$Double = DefaultResultStub.class$("java.lang.Double")) : class$java$lang$Double, new Double(0.0));
        this.addResult(class$java$lang$String == null ? (class$java$lang$String = DefaultResultStub.class$("java.lang.String")) : class$java$lang$String, "");
        this.addResult(class$java$lang$Object == null ? (class$java$lang$Object = DefaultResultStub.class$("java.lang.Object")) : class$java$lang$Object, new Object());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

