/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.multi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.util.configuration.ConfigurationRepository;
import org.objectweb.carol.util.configuration.ProtocolConfiguration;
import org.objectweb.carol.util.configuration.TraceCarol;

public class MultiPRODelegate
implements PortableRemoteObjectDelegate {
    private Hashtable exported = new Hashtable();
    private List proDelegates = null;

    public MultiPRODelegate() {
        ProtocolConfiguration[] protocolConfigurations = ConfigurationRepository.getConfigurations();
        this.proDelegates = new ArrayList();
        for (int i = 0; i < protocolConfigurations.length; ++i) {
            PortableRemoteObjectDelegate proDelegate = protocolConfigurations[i].getProtocol().getPortableRemoteObject();
            this.proDelegates.add(proDelegate);
        }
    }

    public void exportObject(Remote obj) throws RemoteException {
        Iterator it = this.proDelegates.iterator();
        while (it.hasNext()) {
            ((PortableRemoteObjectDelegate)it.next()).exportObject(obj);
        }
        if (TraceCarol.isDebugExportCarol()) {
            TraceCarol.debugExportCarol("Export object " + obj.getClass().getName());
            this.addObject(obj.getClass().getName());
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        Iterator it = this.proDelegates.iterator();
        while (it.hasNext()) {
            ((PortableRemoteObjectDelegate)it.next()).unexportObject(obj);
        }
        if (TraceCarol.isDebugExportCarol()) {
            TraceCarol.debugExportCarol("Unexport object " + obj.getClass().getName());
            TraceCarol.debugExportCarol("UnExported objects list:\n" + this.getExportedObjects());
            this.removeObject(obj.getClass().getName());
        }
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        Iterator it = this.proDelegates.iterator();
        while (it.hasNext()) {
            ((PortableRemoteObjectDelegate)it.next()).connect(target, source);
        }
    }

    public Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        return ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject().narrow(narrowFrom, narrowTo);
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        return ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject().toStub(obj);
    }

    private String getExportedObjects() {
        String result = "Exported Objects:\n";
        int resultInt = 0;
        Enumeration e = this.exported.keys();
        while (e.hasMoreElements()) {
            String ck = (String)e.nextElement();
            int on = (Integer)this.exported.get(ck);
            result = result + "" + on + " instances of  " + ck + "\n";
            resultInt += on;
        }
        result = result + "Total number of exported objects=" + resultInt;
        return result;
    }

    private void removeObject(String className) {
        if (this.exported.containsKey(className)) {
            if ((Integer)this.exported.get(className) != 1) {
                this.exported.put(className, new Integer((Integer)this.exported.get(className) - 1));
            } else {
                this.exported.remove(className);
            }
        }
    }

    private void addObject(String className) {
        if (this.exported.containsKey(className)) {
            this.exported.put(className, new Integer((Integer)this.exported.get(className) + 1));
        } else {
            this.exported.put(className, new Integer(1));
        }
    }
}

