/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.objectweb.carol.jndi.ns.AbsRegistry;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.jndi.registry.ManageableRegistry;
import org.objectweb.carol.jndi.registry.RMIFixedPortFirewallSocketFactory;
import org.objectweb.carol.rmi.util.PortNumber;
import org.objectweb.carol.util.configuration.TraceCarol;

public class IRMIRegistry
extends AbsRegistry
implements NameService {
    private static final int DEFAULT_PORT_NUMBER = 1098;
    private static int objectPort = 0;
    private static Registry registry = null;

    public IRMIRegistry() {
        super(1098);
    }

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("IRMIRegistry.start() on port:" + this.getPort());
        }
        try {
            if (System.getProperty("carol.server.mode", "false").equalsIgnoreCase("true")) {
                if (this.getConfigProperties() != null) {
                    String propertyName = "carol.irmi.server.port";
                    objectPort = PortNumber.strToint(this.getConfigProperties().getProperty(propertyName, "0"), propertyName);
                } else {
                    TraceCarol.debugCarol("No properties 'carol.irmi.server.port' defined in carol.properties file.");
                }
            }
            if (objectPort > 0) {
                RMIFixedPortFirewallSocketFactory.register(objectPort);
            }
            if (!this.isStarted()) {
                if (objectPort > 0) {
                    TraceCarol.infoCarol("Using IRMI fixed server port number '" + objectPort + "'.");
                }
                if (this.getPort() >= 0) {
                    registry = ManageableRegistry.createManagableRegistry(this.getPort(), objectPort);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                IRMIRegistry.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("IRMIRegistry ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start IRMIRegistry, port=" + this.getPort() + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("IRMIRegistry is already start on port:" + this.getPort());
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not start rmi registry: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("IRMIRegistry.stop()");
        }
        try {
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            registry = null;
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop rmi registry: " + e);
        }
    }

    public static boolean isLocal() {
        return registry != null;
    }

    public boolean isStarted() {
        if (registry != null) {
            return true;
        }
        try {
            LocateRegistry.getRegistry(this.getPort()).list();
        }
        catch (RemoteException re) {
            return false;
        }
        return true;
    }

    public static Registry getRegistry() {
        return registry;
    }
}

