/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.search;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.webapp.search.SearchException;

@Name(value="searchDelegate")
@Scope(value=ScopeType.SESSION)
public class SearchBusinessDelegate
implements Serializable {
    private static final long serialVersionUID = 786391027463892L;
    private static final Log log = LogFactory.getLog(SearchBusinessDelegate.class);
    @In(create=true, required=false)
    private transient CoreSession documentManager;

    public DocumentModelList searchWithNXQL(String nxql) throws ClientException, SearchException {
        return this.searchWithNXQL(nxql, null);
    }

    public DocumentModelList searchWithNXQL(String nxql, Filter filter) throws ClientException, SearchException {
        String logPrefix = "<searchWithNXQL> ";
        log.debug((Object)("<searchWithNXQL> NXQL: " + nxql));
        try {
            assert (null != this.documentManager) : "documentManager not injected from seam context";
            DocumentModelList resultDocuments = this.documentManager.query(nxql, filter);
            log.debug((Object)("<searchWithNXQL> results contains " + resultDocuments.size() + " docs"));
            return resultDocuments;
        }
        catch (Throwable t) {
            String cause = SearchBusinessDelegate.tryToExtractMeaningfulCause(t);
            if (cause != null) {
                throw new SearchException(cause);
            }
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<DocumentModel> searchWithNXQL(String nxql, Filter filter, int max) throws SearchException, ClientException {
        String logPrefix = "<searchWithNXQL-limit> ";
        log.debug((Object)("<searchWithNXQL-limit> NXQL: " + nxql));
        try {
            assert (null != this.documentManager) : "documentManager not injected from seam context";
            DocumentModelList resultDocuments = this.documentManager.query(nxql, filter, max);
            log.debug((Object)("<searchWithNXQL-limit> results contains " + resultDocuments.size() + " docs"));
            return resultDocuments;
        }
        catch (Throwable t) {
            String cause = SearchBusinessDelegate.tryToExtractMeaningfulCause(t);
            if (cause != null) {
                throw new SearchException(cause);
            }
            throw ClientException.wrap((Throwable)t);
        }
    }

    public DocumentModelIterator pagedSearchWithNXQL(String nxql, Filter filter, int max) throws SearchException, ClientException {
        String logPrefix = "<searchWithNXQL-limit> ";
        log.debug((Object)("<searchWithNXQL-limit> NXQL: " + nxql));
        try {
            assert (null != this.documentManager) : "documentManager not injected from seam context";
            DocumentModelIterator resultDocuments = this.documentManager.queryIt(nxql, filter, max);
            log.debug((Object)("<searchWithNXQL-limit> results contains " + resultDocuments.size() + " docs"));
            return resultDocuments;
        }
        catch (Throwable t) {
            String cause = SearchBusinessDelegate.tryToExtractMeaningfulCause(t);
            if (cause != null) {
                throw new SearchException(cause);
            }
            throw ClientException.wrap((Throwable)t);
        }
    }

    public DocumentModelList searchForText(String keywords) throws ClientException, SearchException {
        return this.searchForText(keywords, null);
    }

    public DocumentModelList searchForText(String keywords, Filter filter) throws ClientException, SearchException {
        String logPrefix = "<searchForText> ";
        try {
            log.debug((Object)("<searchForText> Making call to get documents list for keywords: " + keywords));
            assert (null != this.documentManager) : "documentManager not injected from Seam context";
            DocumentModelList resultDocuments = this.documentManager.querySimpleFts(keywords, filter);
            log.debug((Object)("<searchForText> result contains: " + resultDocuments.size() + " docs"));
            return resultDocuments;
        }
        catch (Throwable t) {
            String cause = SearchBusinessDelegate.tryToExtractMeaningfulCause(t);
            if (cause != null) {
                throw new SearchException(cause);
            }
            throw ClientException.wrap((Throwable)t);
        }
    }

    public DocumentModelIterator pagedSearchForText(String keywords, Filter filter, int pageSize) throws ClientException, SearchException {
        String logPrefix = "<pagedSearchForText> ";
        try {
            log.debug((Object)("<pagedSearchForText> Making call to get documents list for keywords: " + keywords));
            assert (null != this.documentManager) : "documentManager not injected from seam context";
            DocumentModelIterator resultDocuments = this.documentManager.querySimpleFtsIt(keywords, filter, pageSize);
            log.debug((Object)("<pagedSearchForText> result contains: " + resultDocuments.size() + " docs"));
            return resultDocuments;
        }
        catch (Throwable t) {
            String cause = SearchBusinessDelegate.tryToExtractMeaningfulCause(t);
            if (cause != null) {
                throw new SearchException(cause);
            }
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<DocumentModel> searchForText(String keywords, Filter filter, int maxResultsCount) throws SearchException, ClientException {
        String logPrefix = "<searchForText-limit> ";
        try {
            log.debug((Object)("<searchForText-limit> Making call to get documents list for keywords: " + keywords));
            assert (null != this.documentManager) : "documentManager not injected from seam context";
            DocumentModelList resultDocuments = this.documentManager.querySimpleFts(keywords, filter);
            log.debug((Object)("<searchForText-limit> result contains: " + resultDocuments.size() + " docs"));
            return resultDocuments;
        }
        catch (Throwable t) {
            String cause = SearchBusinessDelegate.tryToExtractMeaningfulCause(t);
            if (cause != null) {
                throw new SearchException(cause);
            }
            throw ClientException.wrap((Throwable)t);
        }
    }

    private static String tryToExtractMeaningfulCause(Throwable t) {
        if (t instanceof ClientException) {
            String parentCauseMsg;
            if (t.getCause() != null && (parentCauseMsg = ExceptionUtils.getRootCause((Throwable)t).getMessage()) != null && parentCauseMsg.trim().length() > 0) {
                return parentCauseMsg;
            }
            return t.getMessage();
        }
        if (t.getCause() != null) {
            return SearchBusinessDelegate.tryToExtractMeaningfulCause(t.getCause());
        }
        return null;
    }

    public String getDocLocation(DocumentModel doc) {
        Object[] titles;
        assert (doc != null);
        DocumentRef parentRef = doc.getParentRef();
        try {
            titles = this.documentManager.getDataModelsFieldUp(parentRef, "dublincore", "title");
        }
        catch (ClientException e) {
            log.error((Object)e);
            return null;
        }
        StringBuilder location = new StringBuilder();
        for (int i = titles.length - 2; i >= 0; --i) {
            Object title = titles[i];
            location.append('/');
            location.append(title);
        }
        if (titles.length == 1) {
            location.append('/');
        }
        return location.toString();
    }
}

