/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class TableImpl
implements Table {
    private static final long serialVersionUID = 1L;
    protected final Dialect dialect;
    protected final String key;
    protected final String name;
    private final LinkedHashMap<String, Column> columns;
    private Column primaryColumn;
    private final List<String[]> indexedColumns;
    private final Map<String[], String> fulltextIndexedColumns;

    public TableImpl(Dialect dialect, String name, String key) {
        this.dialect = dialect;
        this.key = key;
        this.name = name;
        this.columns = new LinkedHashMap();
        this.indexedColumns = new LinkedList<String[]>();
        this.fulltextIndexedColumns = new HashMap<String[], String>();
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public Table getRealTable() {
        return this;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getPhysicalName() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.dialect.openQuote() + this.name + this.dialect.closeQuote();
    }

    @Override
    public String getQuotedSuffixedName(String suffix) {
        return this.dialect.openQuote() + this.name + suffix + this.dialect.closeQuote();
    }

    @Override
    public Column getColumn(String name) {
        return this.columns.get(name);
    }

    @Override
    public Column getPrimaryColumn() {
        if (this.primaryColumn == null) {
            for (Column column : this.columns.values()) {
                if (!column.isPrimary()) continue;
                this.primaryColumn = column;
                break;
            }
        }
        return this.primaryColumn;
    }

    @Override
    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    public Column addColumn(String name, Column column) {
        if (this.columns.containsKey(name)) {
            throw new IllegalArgumentException("duplicate column " + name);
        }
        this.columns.put(name, column);
        return column;
    }

    @Override
    public Column addColumn(String name, ColumnType type, String key, Model model) {
        String physicalName = this.dialect.getColumnName(name);
        Column column = new Column(this, physicalName, type, key);
        return this.addColumn(name, column);
    }

    @Override
    public void addIndex(String ... columnNames) {
        this.indexedColumns.add(columnNames);
    }

    @Override
    public void addFulltextIndex(String indexName, String ... columnNames) {
        this.addIndex(columnNames);
        this.fulltextIndexedColumns.put(columnNames, indexName);
    }

    @Override
    public boolean hasFulltextIndex() {
        return !this.fulltextIndexedColumns.isEmpty();
    }

    @Override
    public String getCreateSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ");
        buf.append(this.getQuotedName());
        buf.append(" (");
        Iterator<Column> it = this.columns.values().iterator();
        while (it.hasNext()) {
            this.addOneColumn(buf, it.next());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(')');
        buf.append(this.dialect.getTableTypeString(this));
        return buf.toString();
    }

    @Override
    public String getAddColumnSql(Column column) {
        StringBuilder buf = new StringBuilder();
        buf.append("ALTER TABLE ");
        buf.append(this.getQuotedName());
        buf.append(' ');
        buf.append(this.dialect.getAddColumnString());
        buf.append(' ');
        this.addOneColumn(buf, column);
        return buf.toString();
    }

    protected void addOneColumn(StringBuilder buf, Column column) {
        buf.append(column.getQuotedName());
        buf.append(' ');
        buf.append(column.getSqlTypeString());
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            buf.append(" DEFAULT ");
            buf.append(defaultValue);
        }
        if (column.isNullable()) {
            buf.append(this.dialect.getNullColumnString());
        } else {
            buf.append(" NOT NULL");
        }
    }

    @Override
    public List<String> getPostCreateSqls(Model model) {
        LinkedList<String> sqls = new LinkedList<String>();
        for (Column column : this.columns.values()) {
            this.postAddColumn(column, sqls, model);
        }
        return sqls;
    }

    @Override
    public List<String> getPostAddSqls(Column column, Model model) {
        LinkedList<String> sqls = new LinkedList<String>();
        this.postAddColumn(column, sqls, model);
        return sqls;
    }

    protected void postAddColumn(Column column, List<String> sqls, Model model) {
        Table ft;
        if (!(!column.isPrimary() || column.isIdentity() && this.dialect.isIdentityAlreadyPrimary())) {
            StringBuilder buf = new StringBuilder();
            String constraintName = this.dialect.openQuote() + this.dialect.getPrimaryKeyConstraintName(this.key) + this.dialect.closeQuote();
            buf.append("ALTER TABLE ");
            buf.append(this.getQuotedName());
            buf.append(this.dialect.getAddPrimaryKeyConstraintString(constraintName));
            buf.append('(');
            buf.append(column.getQuotedName());
            buf.append(')');
            sqls.add(buf.toString());
        }
        if (column.isIdentity()) {
            sqls.addAll(this.dialect.getPostCreateIdentityColumnSql(column));
        }
        if ((ft = column.getForeignTable()) != null) {
            Column fc = ft.getColumn(column.getForeignKey());
            String constraintName = this.dialect.openQuote() + this.dialect.getForeignKeyConstraintName(this.key, column.getPhysicalName(), ft.getPhysicalName()) + this.dialect.closeQuote();
            StringBuilder buf = new StringBuilder();
            buf.append("ALTER TABLE ");
            buf.append(this.getQuotedName());
            buf.append(this.dialect.getAddForeignKeyConstraintString(constraintName, new String[]{column.getQuotedName()}, ft.getQuotedName(), new String[]{fc.getQuotedName()}, true));
            if (this.dialect.supportsCircularCascadeDeleteConstraints() || "id".equals(fc.getPhysicalName()) && "id".equals(column.getPhysicalName())) {
                buf.append(" ON DELETE CASCADE");
            }
            sqls.add(buf.toString());
        }
        String columnName = column.getKey();
        block0: for (String[] columnNames : this.indexedColumns) {
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(columnNames));
            if (!names.contains(columnName)) continue;
            for (Column c : this.getColumns()) {
                String key = c.getKey();
                names.remove(key);
                if (!names.isEmpty()) continue;
                if (!columnName.equals(key)) continue block0;
            }
            ArrayList<Column> cols = new ArrayList<Column>(columnNames.length);
            ArrayList<String> qcols = new ArrayList<String>(columnNames.length);
            ArrayList<String> pcols = new ArrayList<String>(columnNames.length);
            for (String name : columnNames) {
                Column col = this.getColumn(name);
                cols.add(col);
                qcols.add(col.getQuotedName());
                pcols.add(col.getPhysicalName());
            }
            String quotedIndexName = this.dialect.openQuote() + this.dialect.getIndexName(this.key, pcols) + this.dialect.closeQuote();
            String indexName = this.fulltextIndexedColumns.get(columnNames);
            String createIndexSql = indexName != null ? this.dialect.getCreateFulltextIndexSql(indexName, quotedIndexName, this, cols, model) : this.dialect.getCreateIndexSql(quotedIndexName, this.getQuotedName(), qcols);
            sqls.add(createIndexSql);
        }
    }

    @Override
    public String getDropSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("DROP TABLE ");
        if (this.dialect.supportsIfExistsBeforeTableName()) {
            buf.append("IF EXISTS ");
        }
        buf.append(this.getQuotedName());
        buf.append(this.dialect.getCascadeDropConstraintsString());
        if (this.dialect.supportsIfExistsAfterTableName()) {
            buf.append(" IF EXISTS");
        }
        return buf.toString();
    }

    public String toString() {
        return "Table(" + this.name + ')';
    }
}

