/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.SQLStatement;

public class SQLInfo {
    private static final String ORDER_DESC = "DESC";
    private static final String ORDER_ASC = "ASC";
    public final Database database;
    public final Dialect dialect;
    private final Model model;
    private String selectRootIdSql;
    private Column selectRootIdWhatColumn;
    private final Map<String, String> insertSqlMap;
    private final Map<String, List<Column>> insertColumnsMap;
    private final Map<String, String> deleteSqlMap;
    private Map<SelectionType, SQLInfoSelection> selections;
    private String selectChildrenIdsAndTypesSql;
    private String selectComplexChildrenIdsAndTypesSql;
    private List<Column> selectChildrenIdsAndTypesWhatColumns;
    private String selectDescendantsInfoSql;
    private List<Column> selectDescendantsInfoWhatColumns;
    private final Map<String, String> copySqlMap;
    private final Map<String, Column> copyIdColumnMap;
    protected final Map<String, SQLInfoSelect> selectFragmentById;
    protected List<Column> clusterInvalidationsColumns;
    protected Map<String, List<SQLStatement>> sqlStatements;
    protected Map<String, Serializable> sqlStatementsProperties;
    protected List<String> getBinariesSql;
    protected List<Column> getBinariesColumns;
    private static String[] NO_ORDER_BY = new String[0];

    public SQLInfo(Model model, Dialect dialect) throws StorageException {
        this.model = model;
        this.dialect = dialect;
        this.database = new Database(dialect);
        this.selectRootIdSql = null;
        this.selectRootIdWhatColumn = null;
        this.selectFragmentById = new HashMap<String, SQLInfoSelect>();
        this.selections = new HashMap<SelectionType, SQLInfoSelection>();
        this.selectChildrenIdsAndTypesSql = null;
        this.selectChildrenIdsAndTypesWhatColumns = null;
        this.selectComplexChildrenIdsAndTypesSql = null;
        this.insertSqlMap = new HashMap<String, String>();
        this.insertColumnsMap = new HashMap<String, List<Column>>();
        this.deleteSqlMap = new HashMap<String, String>();
        this.copySqlMap = new HashMap<String, String>();
        this.copyIdColumnMap = new HashMap<String, Column>();
        this.getBinariesSql = new ArrayList<String>(1);
        this.getBinariesColumns = new ArrayList<Column>(1);
        this.initSQL();
        this.initSelections();
        try {
            this.initSQLStatements(JDBCMapper.testProps);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getSelectRootIdSql() {
        return this.selectRootIdSql;
    }

    public Column getSelectRootIdWhatColumn() {
        return this.selectRootIdWhatColumn;
    }

    public String getInsertRootIdSql() {
        return this.insertSqlMap.get("repositories");
    }

    public List<Column> getInsertRootIdColumns() {
        return this.insertColumnsMap.get("repositories");
    }

    public SQLInfoSelection getSelection(SelectionType type) {
        return this.selections.get((Object)type);
    }

    public String getSelectChildrenIdsAndTypesSql(boolean onlyComplex) {
        return onlyComplex ? this.selectComplexChildrenIdsAndTypesSql : this.selectChildrenIdsAndTypesSql;
    }

    public List<Column> getSelectChildrenIdsAndTypesWhatColumns() {
        return this.selectChildrenIdsAndTypesWhatColumns;
    }

    public String getSelectDescendantsInfoSql() {
        return this.selectDescendantsInfoSql;
    }

    public List<Column> getSelectDescendantsInfoWhatColumns() {
        return this.selectDescendantsInfoWhatColumns;
    }

    public List<Column> getClusterInvalidationsColumns() {
        return this.clusterInvalidationsColumns;
    }

    public String getInsertSql(String tableName) {
        return this.insertSqlMap.get(tableName);
    }

    public List<Column> getInsertColumns(String tableName) {
        return this.insertColumnsMap.get(tableName);
    }

    public SQLInfoSelect getUpdateById(String tableName, Collection<String> keys) {
        Table table = this.database.getTable(tableName);
        Column mainColumn = table.getColumn("id");
        LinkedList<Column> columns = new LinkedList<Column>();
        for (String key : keys) {
            columns.add(table.getColumn(key));
        }
        Update update = new Update(table);
        update.setUpdatedColumns(columns);
        update.setWhere(mainColumn.getQuotedName() + " = ?");
        columns.add(mainColumn);
        return new SQLInfoSelect(update.getStatement(), columns, null, null);
    }

    public Update getUpdateByIdForKeys(String tableName, List<String> keys) {
        Table table = this.database.getTable(tableName);
        Column mainColumn = table.getColumn("id");
        LinkedList<Column> columns = new LinkedList<Column>();
        for (String key : keys) {
            columns.add(table.getColumn(key));
        }
        Update update = new Update(table);
        update.setUpdatedColumns(columns);
        update.setWhere(mainColumn.getQuotedName() + " = ?");
        return update;
    }

    public SQLInfoSelect getSelectFragmentsByIds(String tableName, int nids) {
        return this.getSelectFragmentsByIds(tableName, nids, null, null);
    }

    public SQLInfoSelect getSelectFragmentsByIds(String tableName, int nids, String[] orderBys, Set<String> skipColumns) {
        Table table = this.database.getTable(tableName);
        LinkedList<Column> whatColumns = new LinkedList<Column>();
        LinkedList<String> whats = new LinkedList<String>();
        LinkedList<Column> opaqueColumns = new LinkedList<Column>();
        for (Column column : table.getColumns()) {
            if (column.isOpaque()) {
                opaqueColumns.add(column);
                continue;
            }
            if (skipColumns != null && skipColumns.contains(column.getKey())) continue;
            whatColumns.add(column);
            whats.add(column.getQuotedName());
        }
        Column whereColumn = table.getColumn("id");
        StringBuilder wherebuf = new StringBuilder(whereColumn.getQuotedName());
        wherebuf.append(" IN (");
        for (int i = 0; i < nids; ++i) {
            if (i != 0) {
                wherebuf.append(", ");
            }
            wherebuf.append('?');
        }
        wherebuf.append(')');
        Select select = new Select(table);
        select.setWhat(StringUtils.join(whats, (String)", "));
        select.setFrom(table.getQuotedName());
        select.setWhere(wherebuf.toString());
        if (orderBys != null) {
            LinkedList<String> orders = new LinkedList<String>();
            for (String orderBy : orderBys) {
                orders.add(table.getColumn(orderBy).getQuotedName());
            }
            select.setOrderBy(StringUtils.join(orders, (String)", "));
        }
        return new SQLInfoSelect(select.getStatement(), whatColumns, Collections.singletonList(whereColumn), opaqueColumns.isEmpty() ? null : opaqueColumns);
    }

    public SQLInfoSelect getSelectAncestorsIds() {
        String sql = this.dialect.getAncestorsIdsSql();
        if (sql == null) {
            return null;
        }
        Table table = this.database.getTable("hierarchy");
        Column mainColumn = table.getColumn("id");
        return new SQLInfoSelect(sql, Collections.singletonList(mainColumn), null, null);
    }

    public SQLInfoSelect getSelectParentIds(int nids) {
        Table table = this.database.getTable("hierarchy");
        Column whatColumn = table.getColumn("parentid");
        Column whereColumn = table.getColumn("id");
        StringBuilder wherebuf = new StringBuilder(whereColumn.getQuotedName());
        wherebuf.append(" IN (");
        for (int i = 0; i < nids; ++i) {
            if (i != 0) {
                wherebuf.append(", ");
            }
            wherebuf.append('?');
        }
        wherebuf.append(')');
        Select select = new Select(table);
        select.setWhat("DISTINCT " + whatColumn.getQuotedName());
        select.setFrom(table.getQuotedName());
        select.setWhere(wherebuf.toString());
        return new SQLInfoSelect(select.getStatement(), Collections.singletonList(whatColumn), Collections.singletonList(whereColumn), null);
    }

    public String getDeleteSql(String tableName) {
        return this.deleteSqlMap.get(tableName);
    }

    public String getDeleteSql(String tableName, int n) {
        Table table = this.database.getTable(tableName);
        Delete delete = new Delete(table);
        String where = null;
        for (Column column : table.getColumns()) {
            if (!column.getKey().equals("id")) continue;
            StringBuilder buf = new StringBuilder();
            buf.append(column.getQuotedName());
            if (n == 1) {
                buf.append(" = ?");
            } else {
                buf.append(" IN (");
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append("?");
                }
                buf.append(")");
            }
            where = buf.toString();
        }
        delete.setWhere(where);
        return delete.getStatement();
    }

    public SQLInfoSelect getCopyHier(boolean explicitName, boolean resetVersion) {
        Table table = this.database.getTable("hierarchy");
        Collection<Column> columns = table.getColumns();
        ArrayList<String> selectWhats = new ArrayList<String>(columns.size());
        ArrayList<Column> selectWhatColumns = new ArrayList<Column>(5);
        Insert insert = new Insert(table);
        for (Column column : columns) {
            String quotedName;
            block4: {
                block3: {
                    if (column.isIdentity()) continue;
                    insert.addColumn(column);
                    quotedName = column.getQuotedName();
                    String key = column.getKey();
                    if (key.equals("id")) break block3;
                    if (key.equals("parentid")) break block3;
                    if (key.equals("baseversionid")) break block3;
                    if (key.equals("ischeckedin")) break block3;
                    if (key.equals("minorversion") && resetVersion) break block3;
                    if (key.equals("majorversion") && resetVersion) break block3;
                    if (!key.equals("name") || !explicitName) break block4;
                }
                selectWhats.add("?");
                selectWhatColumns.add(column);
                continue;
            }
            selectWhats.add(quotedName);
        }
        Column whereColumn = table.getColumn("id");
        Select select = new Select(null);
        select.setFrom(table.getQuotedName());
        select.setWhat(StringUtils.join(selectWhats, (String)", "));
        select.setWhere(whereColumn.getQuotedName() + " = ?");
        insert.setValues(select.getStatement());
        String sql = insert.getStatement();
        return new SQLInfoSelect(sql, selectWhatColumns, Collections.singletonList(whereColumn), null);
    }

    public String getCopySql(String tableName) {
        return this.copySqlMap.get(tableName);
    }

    public Column getCopyIdColumn(String tableName) {
        return this.copyIdColumnMap.get(tableName);
    }

    protected void initSQL() throws StorageException {
        if (this.model.getRepositoryDescriptor().clusteringEnabled) {
            if (!this.dialect.isClusteringSupported()) {
                throw new StorageException("Clustering not supported for " + this.dialect.getClass().getSimpleName());
            }
            this.initClusterSQL();
        }
        this.initHierarchySQL();
        this.initRepositorySQL();
        if (this.dialect.supportsAncestorsTable()) {
            this.initAncestorsSQL();
        }
        for (String tableName : this.model.getFragmentNames()) {
            if (tableName.equals("hierarchy")) continue;
            this.initFragmentSQL(tableName);
        }
        Table hierTable = this.database.getTable("hierarchy");
        Table versionTable = this.database.getTable("versions");
        String[] stringArray = new String[1];
        stringArray[0] = "isversion";
        hierTable.addIndex(stringArray);
        String[] stringArray2 = new String[1];
        stringArray2[0] = "versionableid";
        versionTable.addIndex(stringArray2);
        Table proxyTable = this.database.getTable("proxies");
        String[] stringArray3 = new String[1];
        stringArray3[0] = "versionableid";
        proxyTable.addIndex(stringArray3);
        String[] stringArray4 = new String[1];
        stringArray4[0] = "targetid";
        proxyTable.addIndex(stringArray4);
        this.initSelectDescendantsSQL();
        if (!this.model.getRepositoryDescriptor().fulltextDisabled) {
            Table table = this.database.getTable("fulltext");
            ModelFulltext fulltextInfo = this.model.getFulltextInfo();
            if (fulltextInfo.indexNames.size() > 1 && !this.dialect.supportsMultipleFulltextIndexes()) {
                String msg = String.format("SQL database supports only one fulltext index, but %d are configured: %s", fulltextInfo.indexNames.size(), fulltextInfo.indexNames);
                throw new StorageException(msg);
            }
            for (String indexName : fulltextInfo.indexNames) {
                String suffix = this.model.getFulltextIndexSuffix(indexName);
                int ftic = this.dialect.getFulltextIndexedColumns();
                if (ftic == 1) {
                    String[] stringArray5 = new String[1];
                    stringArray5[0] = "fulltext" + suffix;
                    table.addFulltextIndex(indexName, stringArray5);
                    continue;
                }
                if (ftic != 2) continue;
                String[] stringArray6 = new String[2];
                stringArray6[0] = "simpletext" + suffix;
                stringArray6[1] = "binarytext" + suffix;
                table.addFulltextIndex(indexName, stringArray6);
            }
        }
        for (Map.Entry<String, List<String>> e : this.model.getBinaryPropertyInfos().entrySet()) {
            String tableName = e.getKey();
            Table table = this.database.getTable(tableName);
            for (String key : e.getValue()) {
                Select select = new Select(table);
                Column col = table.getColumn(key);
                select.setWhat("DISTINCT " + col.getQuotedName());
                select.setFrom(table.getQuotedName());
                this.getBinariesSql.add(select.getStatement());
                Column resCol = new Column(table, null, ColumnType.STRING, null);
                this.getBinariesColumns.add(resCol);
            }
        }
    }

    protected void initClusterSQL() {
        TableMaker maker = new TableMaker("cluster_nodes");
        maker.newColumn("nodeid", ColumnType.CLUSTERNODE);
        maker.newColumn("created", ColumnType.TIMESTAMP);
        maker = new TableMaker("cluster_invals");
        maker.newColumn("nodeid", ColumnType.CLUSTERNODE);
        maker.newColumn("id", ColumnType.NODEVAL);
        maker.newColumn("fragments", ColumnType.CLUSTERFRAGS);
        maker.newColumn("kind", ColumnType.TINYINT);
        String[] stringArray = new String[1];
        stringArray[0] = "nodeid";
        maker.table.addIndex(stringArray);
        maker.postProcessClusterInvalidations();
    }

    protected void initRepositorySQL() {
        TableMaker maker = new TableMaker("repositories");
        maker.newColumn("id", ColumnType.NODEIDFK);
        maker.newColumn("name", ColumnType.SYSNAME);
        maker.postProcessRepository();
    }

    protected void initHierarchySQL() {
        TableMaker maker = new TableMaker("hierarchy");
        maker.newColumn("id", ColumnType.NODEID);
        Column column = maker.newColumn("parentid", ColumnType.NODEIDFKNULL);
        maker.newColumn("pos", ColumnType.INTEGER);
        maker.newColumn("name", ColumnType.STRING);
        maker.newColumn("isproperty", ColumnType.BOOLEAN);
        maker.newFragmentFields();
        maker.postProcess();
        maker.postProcessHierarchy();
        String[] stringArray = new String[1];
        stringArray[0] = "parentid";
        maker.table.addIndex(stringArray);
        String[] stringArray2 = new String[2];
        stringArray2[0] = "parentid";
        stringArray2[1] = "name";
        maker.table.addIndex(stringArray2);
        String[] stringArray3 = new String[1];
        stringArray3[0] = "primarytype";
        maker.table.addIndex(stringArray3);
    }

    protected void initSelectDescendantsSQL() {
        Table hierTable = this.database.getTable("hierarchy");
        Table proxyTable = this.database.getTable("proxies");
        Column mainColumn = hierTable.getColumn("id");
        Column[] columnArray = new Column[6];
        columnArray[0] = mainColumn;
        columnArray[1] = hierTable.getColumn("parentid");
        columnArray[2] = hierTable.getColumn("primarytype");
        columnArray[3] = hierTable.getColumn("isproperty");
        columnArray[4] = proxyTable.getColumn("versionableid");
        columnArray[5] = proxyTable.getColumn("targetid");
        List<Column> whatCols = Arrays.asList(columnArray);
        ArrayList<String> whats = new ArrayList<String>(6);
        for (Column col : whatCols) {
            whats.add(col.getFullQuotedName());
        }
        Select select = new Select(null);
        select.setWhat(StringUtils.join(whats, (String)", "));
        String from = hierTable.getQuotedName() + " LEFT JOIN " + proxyTable.getQuotedName() + " ON " + mainColumn.getFullQuotedName() + " = " + proxyTable.getColumn("id").getFullQuotedName();
        select.setFrom(from);
        String where = this.dialect.getInTreeSql(mainColumn.getFullQuotedName());
        select.setWhere(where);
        this.selectDescendantsInfoSql = select.getStatement();
        this.selectDescendantsInfoWhatColumns = whatCols;
    }

    protected void initAncestorsSQL() {
        TableMaker maker = new TableMaker("ancestors");
        maker.newColumn("id", ColumnType.NODEIDFKMUL);
        maker.newColumn("ancestors", ColumnType.NODEARRAY);
    }

    protected void initFragmentSQL(String tableName) {
        TableMaker maker = new TableMaker(tableName);
        ColumnType type = tableName.equals("hierarchy") ? ColumnType.NODEID : (tableName.equals("locks") ? ColumnType.NODEIDPK : (this.model.isCollectionFragment(tableName) ? ColumnType.NODEIDFKMUL : ColumnType.NODEIDFK));
        maker.newColumn("id", type);
        maker.newFragmentFields();
        maker.postProcess();
    }

    protected void initSelections() {
        for (SelectionType selType : SelectionType.values()) {
            this.selections.put(selType, new SQLInfoSelection(selType));
        }
    }

    public static SQLInfoSelect makeSelect(Table table, String[] orderBys, String ... freeColumns) {
        List<String> freeColumnsList = Arrays.asList(freeColumns);
        LinkedList<Column> whatColumns = new LinkedList<Column>();
        LinkedList<Column> whereColumns = new LinkedList<Column>();
        LinkedList<Column> opaqueColumns = new LinkedList<Column>();
        LinkedList<String> whats = new LinkedList<String>();
        LinkedList<String> wheres = new LinkedList<String>();
        for (Column column : table.getColumns()) {
            String qname = column.getQuotedName();
            if (freeColumnsList.contains(column.getKey())) {
                whereColumns.add(column);
                wheres.add(qname + " = ?");
                continue;
            }
            if (column.isOpaque()) {
                opaqueColumns.add(column);
                continue;
            }
            whatColumns.add(column);
            whats.add(qname);
        }
        if (whats.isEmpty()) {
            whats.add(table.getColumn("id").getQuotedName());
        }
        Select select = new Select(table);
        select.setWhat(StringUtils.join(whats, (String)", "));
        select.setFrom(table.getQuotedName());
        select.setWhere(StringUtils.join(wheres, (String)" AND "));
        LinkedList<String> orders = new LinkedList<String>();
        for (int i = 0; i < orderBys.length; ++i) {
            String name = orderBys[i++];
            String ascdesc = orderBys[i].equals(ORDER_DESC) ? " DESC" : "";
            orders.add(table.getColumn(name).getQuotedName() + ascdesc);
        }
        select.setOrderBy(StringUtils.join(orders, (String)", "));
        return new SQLInfoSelect(select.getStatement(), whatColumns, whereColumns, opaqueColumns.isEmpty() ? null : opaqueColumns);
    }

    public void initSQLStatements(Map<String, Serializable> testProps) throws IOException {
        this.sqlStatements = new HashMap<String, List<SQLStatement>>();
        SQLStatement.read(this.dialect.getSQLStatementsFilename(), this.sqlStatements);
        if (!testProps.isEmpty()) {
            SQLStatement.read(this.dialect.getTestSQLStatementsFilename(), this.sqlStatements);
        }
        this.sqlStatementsProperties = this.dialect.getSQLStatementsProperties(this.model, this.database);
        if (!testProps.isEmpty()) {
            this.sqlStatementsProperties.putAll(testProps);
        }
    }

    public void executeSQLStatements(String category, JDBCConnection jdbc) throws SQLException {
        List<SQLStatement> statements = this.sqlStatements.get(category);
        if (statements != null) {
            SQLStatement.execute(statements, this.sqlStatementsProperties, jdbc);
        }
    }

    public int getMaximumArgsForIn() {
        return this.dialect.getMaximumArgsForIn();
    }

    public static class ColumnMapMaker
    implements MapMaker {
        public final List<Column> columns;
        public final List<String> keys;

        public ColumnMapMaker(List<Column> columns) {
            this.columns = columns;
            this.keys = new ArrayList<String>(columns.size());
            for (Column column : columns) {
                this.keys.add(column.getKey());
            }
        }

        public ColumnMapMaker(List<Column> columns, List<String> keys) {
            this.columns = columns;
            this.keys = keys;
        }

        @Override
        public Map<String, Serializable> makeMap(ResultSet rs) throws SQLException {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            int i = 1;
            for (Column column : this.columns) {
                String key = this.keys.get(i - 1);
                Serializable value = column.getFromResultSet(rs, i++);
                map.put(key, value);
            }
            return map;
        }
    }

    public static interface MapMaker {
        public Map<String, Serializable> makeMap(ResultSet var1) throws SQLException;
    }

    public class SQLInfoSelection {
        public final SelectionType type;
        public final SQLInfoSelect selectAll;
        public final SQLInfoSelect selectFiltered;

        public SQLInfoSelection(SelectionType selType) {
            SQLInfoSelect selectFiltered;
            SQLInfoSelect selectAll;
            this.type = selType;
            Table table = SQLInfo.this.database.getTable(selType.tableName);
            if (selType.criterionKey == null) {
                selectAll = SQLInfo.makeSelect(table, NO_ORDER_BY, selType.selKey);
                selectFiltered = SQLInfo.makeSelect(table, NO_ORDER_BY, selType.selKey, selType.filterKey);
            } else {
                selectAll = SQLInfo.makeSelect(table, NO_ORDER_BY, selType.selKey, selType.criterionKey);
                selectFiltered = SQLInfo.makeSelect(table, NO_ORDER_BY, selType.selKey, selType.filterKey, selType.criterionKey);
            }
            this.selectAll = selectAll;
            this.selectFiltered = selectFiltered;
        }
    }

    public static class SQLInfoSelect {
        public final String sql;
        public final List<Column> whatColumns;
        public final MapMaker mapMaker;
        public final List<Column> whereColumns;
        public final List<Column> opaqueColumns;

        public SQLInfoSelect(String sql, List<Column> whatColumns, List<Column> whereColumns, List<Column> opaqueColumns) {
            this(sql, whatColumns, null, whereColumns, opaqueColumns);
        }

        public SQLInfoSelect(String sql, MapMaker mapMaker) {
            this(sql, null, mapMaker, null, null);
        }

        public SQLInfoSelect(String sql, List<Column> whatColumns, MapMaker mapMaker, List<Column> whereColumns, List<Column> opaqueColumns) {
            this.sql = sql;
            this.whatColumns = whatColumns;
            this.mapMaker = mapMaker;
            this.whereColumns = whereColumns == null ? null : new ArrayList<Column>(whereColumns);
            this.opaqueColumns = opaqueColumns == null ? null : new ArrayList<Column>(opaqueColumns);
        }
    }

    protected class TableMaker {
        private final String tableName;
        private final Table table;
        private final String orderBy;

        protected TableMaker(String tableName) {
            this.tableName = tableName;
            this.table = SQLInfo.this.database.addTable(tableName);
            this.orderBy = SQLInfo.this.model.getCollectionOrderBy(tableName);
        }

        protected void newFragmentFields() {
            Map<String, ColumnType> keysType = SQLInfo.this.model.getFragmentKeysType(this.tableName);
            for (Map.Entry<String, ColumnType> entry : keysType.entrySet()) {
                this.newColumn(entry.getKey(), entry.getValue());
            }
        }

        protected Column newColumn(String key, ColumnType type) {
            String columnName = key;
            Column column = this.table.addColumn(columnName, type, key, SQLInfo.this.model);
            if (type == ColumnType.NODEID) {
                column.setNullable(false);
                column.setPrimary(true);
            }
            if (type == ColumnType.NODEIDFK || type == ColumnType.NODEIDPK) {
                column.setNullable(false);
                column.setPrimary(true);
            }
            if (type == ColumnType.NODEIDFKMUL) {
                column.setNullable(false);
                this.table.addIndex(key);
            }
            if (type == ColumnType.NODEIDFK || type == ColumnType.NODEIDFKNP || type == ColumnType.NODEIDFKNULL || type == ColumnType.NODEIDFKMUL) {
                Database database = SQLInfo.this.database;
                SQLInfo.this.model;
                Table table = database.getTable("hierarchy");
                SQLInfo.this.model;
                column.setReferences(table, "id");
            }
            return column;
        }

        protected void postProcessClusterInvalidations() {
            Column[] columnArray = new Column[3];
            SQLInfo.this.model;
            columnArray[0] = this.table.getColumn("id");
            SQLInfo.this.model;
            columnArray[1] = this.table.getColumn("fragments");
            SQLInfo.this.model;
            columnArray[2] = this.table.getColumn("kind");
            SQLInfo.this.clusterInvalidationsColumns = Arrays.asList(columnArray);
        }

        protected void postProcessRepository() {
            this.postProcessRootIdSelect();
            this.postProcessInsert();
        }

        protected void postProcessRootIdSelect() {
            String what = null;
            String where = null;
            for (Column column : this.table.getColumns()) {
                String key = column.getKey();
                String qname = column.getQuotedName();
                SQLInfo.this.model;
                if (key.equals("id")) {
                    what = qname;
                    SQLInfo.this.selectRootIdWhatColumn = column;
                    continue;
                }
                SQLInfo.this.model;
                if (key.equals("name")) {
                    where = qname + " = ?";
                    continue;
                }
                throw new RuntimeException(column.toString());
            }
            Select select = new Select(this.table);
            select.setWhat(what);
            select.setFrom(this.table.getQuotedName());
            select.setWhere(where);
            SQLInfo.this.selectRootIdSql = select.getStatement();
        }

        protected void postProcess() {
            this.postProcessSelectById();
            this.postProcessInsert();
            this.postProcessDelete();
            this.postProcessCopy();
        }

        protected void postProcessHierarchy() {
            this.postProcessSelectChildrenIdsAndTypes();
        }

        protected void postProcessSelectById() {
            String[] stringArray;
            if (this.orderBy == null) {
                stringArray = NO_ORDER_BY;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = this.orderBy;
                stringArray = stringArray2;
                stringArray2[1] = SQLInfo.ORDER_ASC;
            }
            String[] orderBys = stringArray;
            String[] stringArray3 = new String[1];
            SQLInfo.this.model;
            stringArray3[0] = "id";
            SQLInfoSelect select = SQLInfo.makeSelect(this.table, orderBys, stringArray3);
            SQLInfo.this.selectFragmentById.put(this.tableName, select);
        }

        protected void postProcessSelectChildrenIdsAndTypes() {
            ArrayList<Column> whatColumns = new ArrayList<Column>(2);
            ArrayList<String> whats = new ArrayList<String>(2);
            SQLInfo.this.model;
            Column column = this.table.getColumn("id");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            SQLInfo.this.model;
            column = this.table.getColumn("primarytype");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            SQLInfo.this.model;
            column = this.table.getColumn("mixintypes");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            Select select = new Select(this.table);
            select.setWhat(StringUtils.join(whats, (String)", "));
            select.setFrom(this.table.getQuotedName());
            StringBuilder stringBuilder = new StringBuilder();
            SQLInfo.this.model;
            String where = stringBuilder.append(this.table.getColumn("parentid").getQuotedName()).append(" = ?").toString();
            select.setWhere(where);
            SQLInfo.this.selectChildrenIdsAndTypesSql = select.getStatement();
            SQLInfo.this.selectChildrenIdsAndTypesWhatColumns = whatColumns;
            StringBuilder stringBuilder2 = new StringBuilder().append(where).append(" AND ");
            SQLInfo.this.model;
            where = stringBuilder2.append(this.table.getColumn("isproperty").getQuotedName()).append(" = ").append(SQLInfo.this.dialect.toBooleanValueString(true)).toString();
            select.setWhere(where);
            SQLInfo.this.selectComplexChildrenIdsAndTypesSql = select.getStatement();
        }

        protected void postProcessInsert() {
            Collection<Column> columns = this.table.getColumns();
            ArrayList<Column> insertColumns = new ArrayList<Column>(columns.size());
            Insert insert = new Insert(this.table);
            for (Column column : columns) {
                if (column.isIdentity()) continue;
                insertColumns.add(column);
                insert.addColumn(column);
            }
            SQLInfo.this.insertSqlMap.put(this.tableName, insert.getStatement());
            SQLInfo.this.insertColumnsMap.put(this.tableName, insertColumns);
        }

        protected void postProcessDelete() {
            Delete delete = new Delete(this.table);
            LinkedList<String> wheres = new LinkedList<String>();
            for (Column column : this.table.getColumns()) {
                String string = column.getKey();
                SQLInfo.this.model;
                if (!string.equals("id")) continue;
                wheres.add(column.getQuotedName() + " = ?");
            }
            delete.setWhere(StringUtils.join(wheres, (String)" AND "));
            SQLInfo.this.deleteSqlMap.put(this.tableName, delete.getStatement());
        }

        protected void postProcessCopy() {
            Collection<Column> columns = this.table.getColumns();
            ArrayList<String> selectWhats = new ArrayList<String>(columns.size());
            SQLInfo.this.model;
            Column copyIdColumn = this.table.getColumn("id");
            Insert insert = new Insert(this.table);
            for (Column column : columns) {
                if (column.isIdentity()) continue;
                insert.addColumn(column);
                if (column == copyIdColumn) {
                    selectWhats.add("?");
                    continue;
                }
                selectWhats.add(column.getQuotedName());
            }
            Select select = new Select(this.table);
            select.setWhat(StringUtils.join(selectWhats, (String)", "));
            select.setFrom(this.table.getQuotedName());
            select.setWhere(copyIdColumn.getQuotedName() + " = ?");
            insert.setValues(select.getStatement());
            SQLInfo.this.copySqlMap.put(this.tableName, insert.getStatement());
            SQLInfo.this.copyIdColumnMap.put(this.tableName, copyIdColumn);
        }
    }
}

