/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.counters;

import org.javasimon.Callback;
import org.javasimon.SimonManager;
import org.javasimon.SimonState;
import org.nuxeo.runtime.management.counters.CounterHistoryRecorder;
import org.nuxeo.runtime.management.counters.CounterHistoryStack;
import org.nuxeo.runtime.management.counters.CounterManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class CounterManagerImpl
extends DefaultComponent
implements CounterManager {
    public static final String COUNTER_PREFIX = "org.nuxeo";
    protected CounterHistoryRecorder history = new CounterHistoryRecorder(50);

    @Override
    public void enableCounters() {
        SimonManager.getCounter((String)COUNTER_PREFIX).setState(SimonState.ENABLED, true);
    }

    @Override
    public void disableCounters() {
        SimonManager.getCounter((String)COUNTER_PREFIX).setState(SimonState.DISABLED, true);
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        SimonManager.getCounter((String)COUNTER_PREFIX);
        SimonManager.callback().addCallback((Callback)this.history);
    }

    @Override
    public void decreaseCounter(String counterName) {
        if (SimonManager.getCounter((String)counterName).isEnabled()) {
            SimonManager.getCounter((String)counterName).decrease();
        }
    }

    @Override
    public void increaseCounter(String counterName) {
        if (SimonManager.getCounter((String)counterName).isEnabled()) {
            SimonManager.getCounter((String)counterName).increase();
        }
    }

    @Override
    public void decreaseCounter(String counterName, long value) {
        if (SimonManager.getCounter((String)counterName).isEnabled()) {
            SimonManager.getCounter((String)counterName).decrease(value);
        }
    }

    @Override
    public void increaseCounter(String counterName, long value) {
        if (SimonManager.getCounter((String)counterName).isEnabled()) {
            SimonManager.getCounter((String)counterName).increase(value);
        }
    }

    @Override
    public void setCounterValue(String counterName, long value) {
        if (SimonManager.getCounter((String)counterName).isEnabled()) {
            SimonManager.getCounter((String)counterName).set(value);
        }
    }

    @Override
    public CounterHistoryStack getCounterHistory(String counterName) {
        CounterHistoryStack stack = this.history.getCounterHistory(counterName);
        if (stack == null) {
            return new CounterHistoryStack(50);
        }
        return stack;
    }
}

