/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public class IOUtil {
    private static final int BUFFER_SIZE = 4096;

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    public static String readResourceAsString(String resourcePath) {
        return IOUtil.readResourceAsString(resourcePath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResourceAsString(String resourcePath, String charsetName) {
        String string;
        InputStream in = IOUtil.getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IOException("Resource not found");
        }
        InputStreamReader reader = new InputStreamReader(in, charsetName);
        try {
            string = IOUtil.readAsString(reader);
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read resource '" + resourcePath + "'", e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    public static String readAsString(Reader reader) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public static InputStream getResourceAsStream(String resourcePath) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader.getResourceAsStream(resourcePath.replaceFirst("/", ""));
    }
}

