/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.listener;

import java.util.HashSet;
import java.util.Set;
import ognl.OgnlException;
import org.concordion.api.Element;
import org.concordion.internal.command.ThrowableCaughtEvent;
import org.concordion.internal.command.ThrowableCaughtListener;
import org.concordion.internal.util.Check;
import org.concordion.internal.util.IOUtil;

public class ThrowableRenderer
implements ThrowableCaughtListener {
    private static final String TOGGLING_SCRIPT_RESOURCE_PATH = "/org/concordion/internal/resource/visibility-toggler.js";
    private long buttonId = 0L;
    private Set<Element> rootElementsWithScript = new HashSet<Element>();

    public void throwableCaught(ThrowableCaughtEvent event) {
        ++this.buttonId;
        Element element = event.getElement();
        element.appendChild(this.expectedSpan(element));
        element.appendChild(this.exceptionMessage(event.getThrowable().getMessage()));
        element.appendChild(this.stackTraceTogglingButton());
        element.appendChild(this.stackTrace(event.getThrowable(), event.getExpression()));
        this.ensureDocumentHasTogglingScript(element);
    }

    private void ensureDocumentHasTogglingScript(Element element) {
        Element rootElement = element.getRootElement();
        if (!this.rootElementsWithScript.contains(rootElement)) {
            this.rootElementsWithScript.add(rootElement);
            Element head = rootElement.getFirstDescendantNamed("head");
            if (head == null) {
                System.out.println(rootElement.toXML());
            }
            Check.notNull(head, "Document <head> section is missing", new Object[0]);
            Element script = new Element("script").addAttribute("type", "text/javascript");
            head.prependChild(script);
            script.appendText(IOUtil.readResourceAsString(TOGGLING_SCRIPT_RESOURCE_PATH, "UTF-8"));
        }
    }

    private Element expectedSpan(Element element) {
        Element spanExpected = new Element("del").addStyleClass("expected");
        element.moveChildrenTo(spanExpected);
        spanExpected.appendNonBreakingSpaceIfBlank();
        Element spanFailure = new Element("span").addStyleClass("failure");
        spanFailure.appendChild(spanExpected);
        return spanFailure;
    }

    private Element exceptionMessage(String exceptionMessage) {
        return new Element("span").addStyleClass("exceptionMessage").appendText(exceptionMessage);
    }

    private Element stackTraceTogglingButton() {
        return new Element("input").addStyleClass("stackTraceButton").setId("stackTraceButton" + this.buttonId).addAttribute("type", "button").addAttribute("onclick", "javascript:toggleStackTrace('" + this.buttonId + "')").addAttribute("value", "View Stack");
    }

    private Element stackTrace(Throwable t, String expression) {
        Element stackTrace = new Element("span").addStyleClass("stackTrace");
        stackTrace.setId("stackTrace" + this.buttonId);
        Element p = new Element("p").appendText("While evaluating expression: ");
        p.appendChild(new Element("code").appendText(expression));
        stackTrace.appendChild(p);
        this.recursivelyAppendStackTrace(t, stackTrace);
        return stackTrace;
    }

    private void recursivelyAppendStackTrace(Throwable t, Element stackTrace) {
        Throwable reason;
        Element stackTraceExceptionMessage = new Element("span").addStyleClass("stackTraceExceptionMessage").appendText(t.getClass().getName() + ": " + t.getMessage());
        stackTrace.appendChild(stackTraceExceptionMessage);
        for (StackTraceElement traceElement : t.getStackTrace()) {
            stackTrace.appendChild(this.stackTraceElement(traceElement));
        }
        if (t instanceof OgnlException && (reason = ((OgnlException)t).getReason()) != null) {
            this.recursivelyAppendStackTrace(reason, stackTrace);
        }
        if (t.getCause() != null) {
            this.recursivelyAppendStackTrace(t.getCause(), stackTrace);
        }
    }

    private Element stackTraceElement(StackTraceElement traceElement) {
        Element entry = new Element("span").addStyleClass("stackTraceEntry").appendText("at " + traceElement.getClassName()).appendText("." + traceElement.getMethodName());
        if (traceElement.getFileName() == null) {
            entry.appendText(" (Unknown Source)");
        } else {
            entry.appendText(" (" + traceElement.getFileName() + ":" + traceElement.getLineNumber() + ")");
        }
        return entry;
    }
}

