/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.listener;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.concordion.api.Element;
import org.concordion.api.Resource;
import org.concordion.api.Target;
import org.concordion.internal.command.SpecificationProcessingEvent;
import org.concordion.internal.command.SpecificationProcessingListener;
import org.concordion.internal.util.IOUtil;

public class PageFooterRenderer
implements SpecificationProcessingListener {
    private static final String CONCORDION_WEBSITE_URL = "http://www.concordion.org";
    private static final String SOURCE_LOGO_RESOURCE_PATH = "/org/concordion/internal/resource/logo.png";
    private static final Resource TARGET_LOGO_RESOURCE = new Resource("/image/concordion-logo.png");
    private final Target target;
    private long startMillis;
    private static Logger logger = Logger.getLogger(PageFooterRenderer.class.getName());

    public PageFooterRenderer(Target target) {
        this.target = target;
    }

    public void beforeProcessingSpecification(SpecificationProcessingEvent event) {
        this.startMillis = System.currentTimeMillis();
    }

    public void afterProcessingSpecification(SpecificationProcessingEvent event) {
        try {
            this.copyLogoToTarget();
            long millisTaken = System.currentTimeMillis() - this.startMillis;
            this.addFooterToDocument(event.getRootElement(), event.getResource(), millisTaken);
        }
        catch (Throwable t) {
            t.printStackTrace();
            logger.warning("Failed to write page footer. " + t.getMessage());
        }
    }

    private void addFooterToDocument(Element rootElement, Resource resource, long millisTaken) {
        Element body = rootElement.getFirstChildElement("body");
        if (body != null) {
            Element footer = new Element("div");
            footer.addStyleClass("footer");
            footer.appendText("Results generated by ");
            Element link = new Element("a");
            link.addAttribute("href", CONCORDION_WEBSITE_URL);
            footer.appendChild(link);
            Element img = new Element("img");
            img.addAttribute("src", resource.getRelativePath(TARGET_LOGO_RESOURCE));
            img.addAttribute("alt", "Concordion");
            img.addAttribute("border", "0");
            link.appendChild(img);
            Element dateDiv = new Element("div");
            dateDiv.addStyleClass("testTime");
            dateDiv.appendText("in " + (millisTaken + 1L) + " ms ");
            dateDiv.appendText(new SimpleDateFormat("'on' dd-MMM-yyyy 'at' HH:mm:ss z").format(new Date()));
            footer.appendChild(dateDiv);
            body.appendChild(footer);
        }
    }

    private void copyLogoToTarget() {
        IOUtil.getResourceAsStream(SOURCE_LOGO_RESOURCE_PATH);
        InputStream inputStream = this.getClass().getResourceAsStream(SOURCE_LOGO_RESOURCE_PATH);
        try {
            this.target.copyTo(TARGET_LOGO_RESOURCE, inputStream);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to copy Concordion logo to target", e);
        }
    }
}

