/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.listener;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.concordion.internal.DocumentParsingListener;
import org.concordion.internal.util.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentStructureImprover
implements DocumentParsingListener {
    @Override
    public void beforeParsing(Document document) {
        Element html = document.getRootElement();
        Check.isTrue("html".equals(html.getLocalName()), "Only <html> documents are supported (<" + html.getLocalName() + "> is not)", new Object[0]);
        if (!this.hasHeadSection(html)) {
            Element head = new Element("head");
            this.copyNodesBeforeBodyIntoHead(html, head);
            html.insertChild((Node)head, 0);
        }
    }

    private void copyNodesBeforeBodyIntoHead(Element html, Element head) {
        for (Node child : this.nodesBeforeBody(html)) {
            child.detach();
            head.appendChild(child);
        }
    }

    private boolean hasHeadSection(Element html) {
        return html.getFirstChildElement("head") != null;
    }

    private List<Node> nodesBeforeBody(Element html) {
        Node child;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < html.getChildCount() && !this.isBodySection(child = html.getChild(i)); ++i) {
            nodes.add(child);
        }
        return nodes;
    }

    private boolean isBodySection(Node child) {
        return child instanceof Element && ((Element)child).getLocalName().equals("body");
    }
}

