/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.listener;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nu.xom.Document;
import org.concordion.api.Element;
import org.concordion.api.Resource;
import org.concordion.api.Source;
import org.concordion.internal.XMLParser;
import org.concordion.internal.command.SpecificationProcessingEvent;
import org.concordion.internal.command.SpecificationProcessingListener;

public class BreadcrumbRenderer
implements SpecificationProcessingListener {
    private static Logger logger = Logger.getLogger(BreadcrumbRenderer.class.getName());
    private final Source source;
    private final XMLParser xmlParser;

    public BreadcrumbRenderer(Source source, XMLParser xmlParser) {
        this.source = source;
        this.xmlParser = xmlParser;
    }

    public void beforeProcessingSpecification(SpecificationProcessingEvent event) {
    }

    public void afterProcessingSpecification(SpecificationProcessingEvent event) {
        try {
            Element span = new Element("span").addStyleClass("breadcrumbs");
            this.appendBreadcrumbsTo(span, event.getResource());
            if (span.hasChildren()) {
                this.getDocumentBody(event.getRootElement()).prependChild(span);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Element getDocumentBody(Element rootElement) {
        Element body = rootElement.getFirstDescendantNamed("body");
        if (body == null) {
            body = new Element("body");
            rootElement.appendChild(body);
        }
        return body;
    }

    private void appendBreadcrumbsTo(Element breadcrumbSpan, Resource documentResource) {
        for (Resource packageResource = documentResource.getParent(); packageResource != null; packageResource = packageResource.getParent()) {
            Resource indexPageResource = packageResource.getRelativeResource(this.getIndexPageName(packageResource));
            if (indexPageResource.equals(documentResource) || !this.source.canFind(indexPageResource)) continue;
            try {
                this.prependBreadcrumb(breadcrumbSpan, this.createBreadcrumbElement(documentResource, indexPageResource));
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to generate breadcrumb", e);
            }
        }
    }

    private String getIndexPageName(Resource packageResource) {
        return BreadcrumbRenderer.capitalize(packageResource.getName()) + ".html";
    }

    private void prependBreadcrumb(Element span, Element breadcrumb) {
        if (span.hasChildren()) {
            span.prependText(" ");
        }
        span.prependText(" >");
        span.prependChild(breadcrumb);
    }

    private Element createBreadcrumbElement(Resource documentResource, Resource indexPageResource) throws IOException {
        Document document = this.xmlParser.parse(this.source.createInputStream(indexPageResource));
        String breadcrumbWording = this.getBreadcrumbWording(new Element(document.getRootElement()), indexPageResource);
        Element a = new Element("a");
        a.addAttribute("href", documentResource.getRelativePath(indexPageResource));
        a.appendText(breadcrumbWording);
        return a;
    }

    private String getBreadcrumbWording(Element rootElement, Resource resource) {
        String heading;
        Element[] headings;
        Element title = rootElement.getFirstDescendantNamed("title");
        if (title != null && !BreadcrumbRenderer.isBlank(title.getText())) {
            return title.getText();
        }
        for (Element h1 : headings = rootElement.getDescendantElements("h1")) {
            if (h1 == null || BreadcrumbRenderer.isBlank(h1.getText())) continue;
            return h1.getText();
        }
        if (resource != null && !BreadcrumbRenderer.isBlank(heading = resource.getName())) {
            heading = this.stripExtension(heading);
            heading = BreadcrumbRenderer.capitalize(heading);
            heading = BreadcrumbRenderer.deCamelCase(heading);
            return heading;
        }
        return "(Up)";
    }

    private static String capitalize(String s) {
        if (s.equals("")) {
            return "";
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private String stripExtension(String s) {
        return s.replaceAll("\\.[a-z]+", "");
    }

    private static String deCamelCase(String s) {
        return s.replaceAll("([0-9a-z])([A-Z])", "$1 $2");
    }

    private static boolean isBlank(String s) {
        return s.replaceAll("[^a-zA-Z0-9]", "").equals("");
    }
}

