/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.command;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.Result;
import org.concordion.api.ResultRecorder;
import org.concordion.internal.CommandCall;
import org.concordion.internal.Row;
import org.concordion.internal.TableSupport;
import org.concordion.internal.command.AbstractCommand;
import org.concordion.internal.command.MissingRowEvent;
import org.concordion.internal.command.SurplusRowEvent;
import org.concordion.internal.command.VerifyRowsListener;
import org.concordion.internal.util.Announcer;
import org.concordion.internal.util.Check;

public class VerifyRowsCommand
extends AbstractCommand {
    private Announcer<VerifyRowsListener> listeners = Announcer.to(VerifyRowsListener.class);

    public void addVerifyRowsListener(VerifyRowsListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeVerifyRowsListener(VerifyRowsListener listener) {
        this.listeners.removeListener(listener);
    }

    public void verify(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        Pattern pattern = Pattern.compile("(#.+?) *: *(.+)");
        Matcher matcher = pattern.matcher(commandCall.getExpression());
        if (!matcher.matches()) {
            throw new RuntimeException("The expression for a \"verifyRows\" should be of the form: #var : collectionExpr");
        }
        String loopVariableName = matcher.group(1);
        String iterableExpression = matcher.group(2);
        Object obj = evaluator.evaluate(iterableExpression);
        Check.notNull(obj, "Expression returned null (should be an Iterable).", new Object[0]);
        Check.isTrue(obj instanceof Iterable, obj.getClass().getCanonicalName() + " is not Iterable", new Object[0]);
        Check.isTrue(!(obj instanceof HashSet) || obj instanceof LinkedHashSet, obj.getClass().getCanonicalName() + " does not have a predictable iteration order", new Object[0]);
        Iterable iterable = (Iterable)obj;
        TableSupport tableSupport = new TableSupport(commandCall);
        Row[] detailRows = tableSupport.getDetailRows();
        int index = 0;
        for (Object loopVar : iterable) {
            Row detailRow;
            evaluator.setVariable(loopVariableName, loopVar);
            if (detailRows.length > index) {
                detailRow = detailRows[index];
            } else {
                detailRow = tableSupport.addDetailRow();
                this.announceSurplusRow(detailRow.getElement());
            }
            tableSupport.copyCommandCallsTo(detailRow);
            commandCall.getChildren().verify(evaluator, resultRecorder);
            ++index;
        }
        while (index < detailRows.length) {
            Row detailRow = detailRows[index];
            resultRecorder.record(Result.FAILURE);
            this.announceMissingRow(detailRow.getElement());
            ++index;
        }
    }

    private void announceMissingRow(Element element) {
        this.listeners.announce().missingRow(new MissingRowEvent(element));
    }

    private void announceSurplusRow(Element element) {
        this.listeners.announce().surplusRow(new SurplusRowEvent(element));
    }
}

