/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.command;

import org.concordion.api.Evaluator;
import org.concordion.api.ResultRecorder;
import org.concordion.internal.CommandCall;
import org.concordion.internal.CommandCallList;
import org.concordion.internal.ExpressionValidator;
import org.concordion.internal.Row;
import org.concordion.internal.TableSupport;
import org.concordion.internal.command.AbstractCommand;

public class ExecuteCommand
extends AbstractCommand {
    private ExpressionValidator expressionValidator;

    public void setExpressionValidator(ExpressionValidator expressionValidator) {
        this.expressionValidator = expressionValidator;
    }

    public void execute(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        if (this.expressionValidator != null) {
            this.expressionValidator.validate(commandCall.getExpression());
        }
        Strategy strategy = commandCall.getElement().isNamed("table") ? new TableStrategy() : new DefaultStrategy();
        strategy.execute(commandCall, evaluator, resultRecorder);
    }

    private class TableStrategy
    implements Strategy {
        private TableStrategy() {
        }

        public void execute(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
            Row[] detailRows;
            TableSupport tableSupport = new TableSupport(commandCall);
            for (Row detailRow : detailRows = tableSupport.getDetailRows()) {
                if (detailRow.getCells().length != tableSupport.getColumnCount()) {
                    throw new RuntimeException("The <table> 'execute' command only supports rows with an equal number of columns.");
                }
                commandCall.setElement(detailRow.getElement());
                tableSupport.copyCommandCallsTo(detailRow);
                commandCall.execute(evaluator, resultRecorder);
            }
        }
    }

    private class DefaultStrategy
    implements Strategy {
        private DefaultStrategy() {
        }

        public void execute(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
            CommandCallList childCommands = commandCall.getChildren();
            childCommands.setUp(evaluator, resultRecorder);
            evaluator.evaluate(commandCall.getExpression());
            childCommands.execute(evaluator, resultRecorder);
            childCommands.verify(evaluator, resultRecorder);
        }
    }

    private static interface Strategy {
        public void execute(CommandCall var1, Evaluator var2, ResultRecorder var3);
    }
}

