/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.util.HashMap;
import java.util.Map;
import org.concordion.api.Element;
import org.concordion.internal.CommandCall;
import org.concordion.internal.CommandCallList;
import org.concordion.internal.Row;
import org.concordion.internal.Table;

public class TableSupport {
    private final CommandCall tableCommandCall;
    private final Map<Integer, CommandCall> commandCallByColumn = new HashMap<Integer, CommandCall>();
    private Table table;

    public TableSupport(CommandCall tableCommandCall) {
        assert (tableCommandCall.getElement().isNamed("table"));
        this.tableCommandCall = tableCommandCall;
        this.table = new Table(tableCommandCall.getElement());
        this.populateCommandCallByColumnMap();
    }

    public int getColumnCount() {
        return this.getLastHeaderRow().getCells().length;
    }

    public Row[] getDetailRows() {
        return this.table.getDetailRows();
    }

    public void copyCommandCallsTo(Row detailRow) {
        int columnIndex = 0;
        for (Element cell : detailRow.getCells()) {
            CommandCall cellCall = this.commandCallByColumn.get(new Integer(columnIndex));
            if (cellCall != null) {
                cellCall.setElement(cell);
            }
            ++columnIndex;
        }
    }

    private void populateCommandCallByColumnMap() {
        Row headerRow = this.getLastHeaderRow();
        CommandCallList children = this.tableCommandCall.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            CommandCall childCall = children.get(i);
            int columnIndex = headerRow.getIndexOfCell(childCall.getElement());
            if (columnIndex == -1) {
                throw new RuntimeException("Commands must be placed on <th> elements when using 'execute' or 'verifyRows' commands on a <table>.");
            }
            this.commandCallByColumn.put(new Integer(columnIndex), childCall);
        }
    }

    public Row getLastHeaderRow() {
        return this.table.getLastHeaderRow();
    }

    public Row addDetailRow() {
        return this.table.addDetailRow();
    }
}

