/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.concordion.api.Result;
import org.concordion.api.ResultRecorder;
import org.concordion.api.ResultSummary;

public class SummarizingResultRecorder
implements ResultRecorder,
ResultSummary {
    private List<Result> recordedResults = new ArrayList<Result>();

    public void record(Result result) {
        this.recordedResults.add(result);
    }

    public void assertIsSatisfied() {
        if (this.hasFailures()) {
            throw new AssertionError((Object)"Specification has failure(s). See output HTML for details.");
        }
        if (this.hasExceptions()) {
            throw new AssertionError((Object)"Specification has exception(s). See output HTML for details.");
        }
    }

    public boolean hasExceptions() {
        return this.getExceptionCount() > 0L;
    }

    private boolean hasFailures() {
        return this.getFailureCount() > 0L;
    }

    public long getCount(Result result) {
        int count = 0;
        for (Result candidate : this.recordedResults) {
            if (candidate != result) continue;
            ++count;
        }
        return count;
    }

    public long getExceptionCount() {
        return this.getCount(Result.EXCEPTION);
    }

    public long getFailureCount() {
        return this.getCount(Result.FAILURE);
    }

    public long getSuccessCount() {
        return this.getCount(Result.SUCCESS);
    }

    public void print(PrintStream out) {
        out.print("Successes: " + this.getSuccessCount());
        out.print(", Failures: " + this.getFailureCount());
        if (this.hasExceptions()) {
            out.print(", Exceptions: " + this.getExceptionCount());
        }
        out.println("\n");
    }
}

