/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.util.Map;
import ognl.MethodFailedException;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.concordion.api.Evaluator;
import org.concordion.internal.InvalidExpressionException;
import org.concordion.internal.util.Check;

public class OgnlEvaluator
implements Evaluator {
    private Object rootObject;
    private final OgnlContext ognlContext = new OgnlContext();

    public OgnlEvaluator() {
    }

    public OgnlEvaluator(Object rootObject) {
        this.rootObject = rootObject;
    }

    public void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
    }

    public Object evaluate(String expression) {
        Check.notNull(this.rootObject, "Root object is null", new Object[0]);
        Check.notNull(expression, "Expression to evaluate cannot be null", new Object[0]);
        try {
            return Ognl.getValue((String)expression, (Map)this.ognlContext, (Object)this.rootObject);
        }
        catch (OgnlException e) {
            throw this.invalidExpressionException(e);
        }
    }

    private InvalidExpressionException invalidExpressionException(OgnlException e) {
        Throwable cause = e;
        String message = e.getMessage();
        if (e.getReason() != null) {
            message = e.getReason().getMessage();
            cause = e.getReason();
        }
        if (message == null) {
            message = "";
        }
        if (e instanceof MethodFailedException) {
            MethodFailedException ex = (MethodFailedException)e;
            Throwable realReason = ex.getReason();
            if (realReason != null) {
                message = realReason instanceof NullPointerException ? "NullPointerException" : realReason.getClass().getName() + ": " + message;
            }
            message = message.replaceAll("java\\.lang\\.", "");
        }
        return new InvalidExpressionException(message, cause);
    }

    public void setVariable(String expression, Object value) {
        this.assertStartsWithHash(expression);
        if (expression.contains("=")) {
            this.evaluate(expression);
        } else {
            String rawVariable = expression.substring(1);
            this.putVariable(rawVariable, value);
        }
    }

    private void assertStartsWithHash(String expression) {
        if (!expression.startsWith("#")) {
            throw new InvalidExpressionException("Variable for concordion:set must start with '#'\n (i.e. change concordion:set=\"" + expression + "\" to concordion:set=\"#" + expression + "\".");
        }
    }

    private void putVariable(String rawVariableName, Object value) {
        Check.isFalse(rawVariableName.startsWith("#"), "Variable name passed to evaluator should not start with #", new Object[0]);
        Check.isTrue(!rawVariableName.equals("in"), "'%s' is a reserved word and cannot be used for variables names", rawVariableName);
        this.ognlContext.put((Object)rawVariableName, value);
    }

    public Object getVariable(String variableName) {
        this.assertStartsWithHash(variableName);
        String rawVariableName = variableName.substring(1);
        return this.ognlContext.get((Object)rawVariableName);
    }
}

