/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.io.File;
import org.concordion.Concordion;
import org.concordion.api.Command;
import org.concordion.api.EvaluatorFactory;
import org.concordion.api.Source;
import org.concordion.api.SpecificationLocator;
import org.concordion.api.SpecificationReader;
import org.concordion.api.Target;
import org.concordion.internal.BannedWordsValidator;
import org.concordion.internal.ClassNameBasedSpecificationLocator;
import org.concordion.internal.ClassPathSource;
import org.concordion.internal.CommandRegistry;
import org.concordion.internal.DocumentParser;
import org.concordion.internal.FileTarget;
import org.concordion.internal.SimpleEvaluatorFactory;
import org.concordion.internal.XMLParser;
import org.concordion.internal.XMLSpecificationReader;
import org.concordion.internal.command.AssertEqualsCommand;
import org.concordion.internal.command.AssertEqualsListener;
import org.concordion.internal.command.AssertTrueCommand;
import org.concordion.internal.command.ExecuteCommand;
import org.concordion.internal.command.LocalTextDecorator;
import org.concordion.internal.command.SetCommand;
import org.concordion.internal.command.SpecificationCommand;
import org.concordion.internal.command.ThrowableCatchingDecorator;
import org.concordion.internal.command.ThrowableCaughtListener;
import org.concordion.internal.command.ThrowableCaughtPublisher;
import org.concordion.internal.command.VerifyRowsCommand;
import org.concordion.internal.listener.AssertEqualsResultRenderer;
import org.concordion.internal.listener.BreadcrumbRenderer;
import org.concordion.internal.listener.DocumentStructureImprover;
import org.concordion.internal.listener.PageFooterRenderer;
import org.concordion.internal.listener.SpecificationExporter;
import org.concordion.internal.listener.StylesheetEmbedder;
import org.concordion.internal.listener.ThrowableRenderer;
import org.concordion.internal.listener.VerifyRowsResultRenderer;
import org.concordion.internal.util.Check;
import org.concordion.internal.util.IOUtil;

public class ConcordionBuilder {
    public static final String NAMESPACE_CONCORDION_2007 = "http://www.concordion.org/2007/concordion";
    private static final String PROPERTY_OUTPUT_DIR = "concordion.output.dir";
    private static final String EMBEDDED_STYLESHEET_RESOURCE = "/org/concordion/internal/resource/embedded.css";
    private SpecificationLocator specificationLocator = new ClassNameBasedSpecificationLocator();
    private Source source = new ClassPathSource();
    private Target target = null;
    private CommandRegistry commandRegistry = new CommandRegistry();
    private DocumentParser documentParser = new DocumentParser(this.commandRegistry);
    private SpecificationReader specificationReader;
    private EvaluatorFactory evaluatorFactory = new SimpleEvaluatorFactory();
    private SpecificationCommand specificationCommand = new SpecificationCommand();
    private AssertEqualsCommand assertEqualsCommand = new AssertEqualsCommand();
    private AssertTrueCommand assertTrueCommand = new AssertTrueCommand();
    private ExecuteCommand executeCommand = new ExecuteCommand();
    private VerifyRowsCommand verifyRowsCommand = new VerifyRowsCommand();
    private File baseOutputDir;
    private ThrowableCaughtPublisher throwableListenerPublisher = new ThrowableCaughtPublisher();

    public ConcordionBuilder() {
        this.throwableListenerPublisher.addThrowableListener(new ThrowableRenderer());
        this.withApprovedCommand("", "specification", this.specificationCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "execute", this.executeCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "set", new SetCommand());
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "assertEquals", this.assertEqualsCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "assertTrue", this.assertTrueCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "verifyRows", this.verifyRowsCommand);
        this.executeCommand.setExpressionValidator(new BannedWordsValidator());
        this.assertEqualsCommand.addAssertEqualsListener(new AssertEqualsResultRenderer());
        this.assertTrueCommand.addAssertEqualsListener(new AssertEqualsResultRenderer());
        this.verifyRowsCommand.addVerifyRowsListener(new VerifyRowsResultRenderer());
        this.documentParser.addDocumentParsingListener(new DocumentStructureImprover());
        String stylesheetContent = IOUtil.readResourceAsString(EMBEDDED_STYLESHEET_RESOURCE);
        this.documentParser.addDocumentParsingListener(new StylesheetEmbedder(stylesheetContent));
    }

    public ConcordionBuilder withSource(Source source) {
        this.source = source;
        return this;
    }

    public ConcordionBuilder withTarget(Target target) {
        this.target = target;
        return this;
    }

    public ConcordionBuilder withEvaluatorFactory(EvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
        return this;
    }

    public ConcordionBuilder withThrowableListener(ThrowableCaughtListener throwableListener) {
        this.throwableListenerPublisher.addThrowableListener(throwableListener);
        return this;
    }

    public ConcordionBuilder withAssertEqualsListener(AssertEqualsListener listener) {
        this.assertEqualsCommand.addAssertEqualsListener(listener);
        return this;
    }

    private ConcordionBuilder withApprovedCommand(String namespaceURI, String commandName, Command command) {
        ThrowableCatchingDecorator throwableCatchingDecorator = new ThrowableCatchingDecorator(new LocalTextDecorator(command));
        throwableCatchingDecorator.addThrowableListener(this.throwableListenerPublisher);
        ThrowableCatchingDecorator decoratedCommand = throwableCatchingDecorator;
        this.commandRegistry.register(namespaceURI, commandName, decoratedCommand);
        return this;
    }

    public ConcordionBuilder withCommand(String namespaceURI, String commandName, Command command) {
        Check.notEmpty(namespaceURI, "Namespace URI is mandatory", new Object[0]);
        Check.notEmpty(commandName, "Command name is mandatory", new Object[0]);
        Check.notNull(command, "Command is null", new Object[0]);
        Check.isFalse(namespaceURI.contains("concordion.org"), "The namespace URI for user-contributed command '" + commandName + "' " + "must not contain 'concordion.org'. Use your own domain name instead.", new Object[0]);
        return this.withApprovedCommand(namespaceURI, commandName, command);
    }

    public Concordion build() {
        if (this.target == null) {
            this.target = new FileTarget(this.getBaseOutputDir());
        }
        XMLParser xmlParser = new XMLParser();
        this.specificationCommand.addSpecificationListener(new BreadcrumbRenderer(this.source, xmlParser));
        this.specificationCommand.addSpecificationListener(new PageFooterRenderer(this.target));
        this.specificationCommand.addSpecificationListener(new SpecificationExporter(this.target));
        this.specificationReader = new XMLSpecificationReader(this.source, xmlParser, this.documentParser);
        return new Concordion(this.specificationLocator, this.specificationReader, this.evaluatorFactory);
    }

    private File getBaseOutputDir() {
        if (this.baseOutputDir != null) {
            return this.baseOutputDir;
        }
        String outputPath = System.getProperty(PROPERTY_OUTPUT_DIR);
        if (outputPath == null) {
            return new File(System.getProperty("java.io.tmpdir"), "concordion");
        }
        return new File(outputPath);
    }
}

