/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.integration.junit4;

import java.lang.reflect.InvocationTargetException;
import org.concordion.integration.junit4.FixtureMethodRoadie;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcordionRunner
extends JUnit4ClassRunner {
    private Description fixtureDescription;

    public ConcordionRunner(Class<?> fixtureClass) throws InitializationError {
        super(fixtureClass);
        this.fixtureDescription = Description.createTestDescription(fixtureClass, (String)"[Concordion Specification]");
    }

    public Description getDescription() {
        Description spec = super.getDescription();
        spec.addChild(this.fixtureDescription);
        return spec;
    }

    protected void validate() throws InitializationError {
        MethodValidator methodValidator = new MethodValidator(this.getTestClass());
        methodValidator.validateNoArgConstructor();
        methodValidator.validateStaticMethods();
        methodValidator.assertValid();
    }

    protected void runMethods(RunNotifier notifier) {
        Object test;
        TestMethod method;
        super.runMethods(notifier);
        Class javaClass = this.getTestClass().getJavaClass();
        Description description = this.fixtureDescription;
        try {
            method = new TestMethod(javaClass.getMethod("getClass", new Class[0]), this.getTestClass());
            test = this.createTest();
        }
        catch (InvocationTargetException e) {
            notifier.testAborted(description, e.getCause());
            return;
        }
        catch (Exception e) {
            notifier.testAborted(description, (Throwable)e);
            return;
        }
        new FixtureMethodRoadie(test, method, notifier, description).run();
    }
}

