/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class WidgetTypeDefinitionRegistry
extends ContributionFragmentRegistry<WidgetTypeDefinition> {
    protected final String category;
    protected final Map<String, WidgetTypeDefinition> widgetTypeDefs;

    public WidgetTypeDefinitionRegistry(String category) {
        this.category = category;
        this.widgetTypeDefs = new HashMap<String, WidgetTypeDefinition>();
    }

    public String getCategory() {
        return this.category;
    }

    public String getContributionId(WidgetTypeDefinition contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, WidgetTypeDefinition contrib, WidgetTypeDefinition newOrigContrib) {
        this.widgetTypeDefs.put(id, contrib);
    }

    public void contributionRemoved(String id, WidgetTypeDefinition origContrib) {
        this.widgetTypeDefs.remove(id);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public WidgetTypeDefinition clone(WidgetTypeDefinition orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(WidgetTypeDefinition src, WidgetTypeDefinition dst) {
        throw new UnsupportedOperationException();
    }

    public List<WidgetTypeDefinition> getDefinitions() {
        ArrayList<WidgetTypeDefinition> res = new ArrayList<WidgetTypeDefinition>();
        for (WidgetTypeDefinition item : this.widgetTypeDefs.values()) {
            if (item == null) continue;
            res.add(item);
        }
        return res;
    }

    public WidgetTypeDefinition getDefinition(String id) {
        return this.widgetTypeDefs.get(id);
    }
}

