/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupCache {
    private static final Logger log = LoggerFactory.getLogger(GroupCache.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private final Map<String, Set<String>> groups = new HashMap<String, Set<String>>();
    private final PartitionNexus nexus;
    private final Hashtable<?, ?> env;
    private AttributeTypeRegistry attributeTypeRegistry;
    private AttributeType memberAT;
    private AttributeType uniqueMemberAT;
    private Map<String, OidNormalizer> normalizerMap;
    private LdapDN administratorsGroupDn;
    private static final Set<LdapDN> EMPTY_GROUPS = new HashSet<LdapDN>();

    public GroupCache(DirectoryServiceConfiguration factoryCfg) throws NamingException {
        this.normalizerMap = factoryCfg.getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.nexus = factoryCfg.getPartitionNexus();
        this.env = (Hashtable)factoryCfg.getEnvironment().clone();
        this.attributeTypeRegistry = factoryCfg.getRegistries().getAttributeTypeRegistry();
        this.memberAT = this.attributeTypeRegistry.lookup("2.5.4.31");
        this.uniqueMemberAT = this.attributeTypeRegistry.lookup("2.5.4.50");
        this.administratorsGroupDn = this.parseNormalized("cn=Administrators,ou=groups,ou=system");
        this.initialize();
    }

    private LdapDN parseNormalized(String name) throws NamingException {
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.normalizerMap);
        return dn;
    }

    private void initialize() throws NamingException {
        BranchNode filter = new BranchNode(AssertionEnum.OR);
        filter.addNode((ExprNode)new SimpleNode("objectClass", "groupOfNames", AssertionEnum.EQUALITY));
        filter.addNode((ExprNode)new SimpleNode("objectClass", "groupOfUniqueNames", AssertionEnum.EQUALITY));
        Iterator<String> suffixes = this.nexus.listSuffixes(null);
        while (suffixes.hasNext()) {
            String suffix = suffixes.next();
            LdapDN baseDn = new LdapDN(suffix);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = this.nexus.search(new SearchOperationContext(baseDn, this.env, (ExprNode)filter, ctls));
            while (results.hasMore()) {
                SearchResult result = results.next();
                LdapDN groupDn = this.parseNormalized(result.getName());
                Attribute members = this.getMemberAttribute(result.getAttributes());
                if (members != null) {
                    HashSet<String> memberSet = new HashSet<String>(members.size());
                    this.addMembers(memberSet, members);
                    this.groups.put(groupDn.getNormName(), memberSet);
                    continue;
                }
                log.warn("Found group '{}' without any member or uniqueMember attributes", (Object)groupDn.getUpName());
            }
            results.close();
        }
        if (IS_DEBUG) {
            log.debug("group cache contents on startup:\n {}", this.groups);
        }
    }

    private Attribute getMemberAttribute(Attributes entry) {
        Attribute oc = entry.get("objectClass");
        if (oc == null) {
            Attribute member = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.memberAT);
            if (member != null) {
                return member;
            }
            Attribute uniqueMember = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.uniqueMemberAT);
            if (uniqueMember != null) {
                return uniqueMember;
            }
            return null;
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"groupOfNames") || AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"2.5.6.9")) {
            return AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.memberAT);
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"groupOfUniqueNames") || AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"2.5.6.17")) {
            return AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.uniqueMemberAT);
        }
        return null;
    }

    private void addMembers(Set<String> memberSet, Attribute members) throws NamingException {
        for (int ii = 0; ii < members.size(); ++ii) {
            String memberDn = (String)members.get(ii);
            try {
                memberDn = this.parseNormalized(memberDn).toString();
            }
            catch (NamingException e) {
                log.warn("Malformed member DN in groupOf[Unique]Names entry.  Member not added to GroupCache.", (Throwable)e);
            }
            memberSet.add(memberDn);
        }
    }

    private void removeMembers(Set<String> memberSet, Attribute members) throws NamingException {
        for (int ii = 0; ii < members.size(); ++ii) {
            String memberDn = (String)members.get(ii);
            try {
                memberDn = this.parseNormalized(memberDn).toString();
            }
            catch (NamingException e) {
                log.warn("Malformed member DN in groupOf[Unique]Names entry.  Member not removed from GroupCache.", (Throwable)e);
            }
            memberSet.remove(memberDn);
        }
    }

    public void groupAdded(LdapDN name, Attributes entry) throws NamingException {
        Attribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        HashSet<String> memberSet = new HashSet<String>(members.size());
        this.addMembers(memberSet, members);
        this.groups.put(name.getNormName(), memberSet);
        if (IS_DEBUG) {
            log.debug("group cache contents after adding '{}' :\n {}", (Object)name.getUpName(), this.groups);
        }
    }

    public void groupDeleted(LdapDN name, Attributes entry) {
        Attribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        this.groups.remove(name.getNormName());
        if (IS_DEBUG) {
            log.debug("group cache contents after deleting '{}' :\n {}", (Object)name.getUpName(), this.groups);
        }
    }

    private void modify(Set<String> memberSet, int modOp, Attribute members) throws NamingException {
        switch (modOp) {
            case 1: {
                this.addMembers(memberSet, members);
                break;
            }
            case 2: {
                if (members.size() <= 0) break;
                memberSet.clear();
                this.addMembers(memberSet, members);
                break;
            }
            case 3: {
                this.removeMembers(memberSet, members);
                break;
            }
            default: {
                throw new InternalError("Undefined modify operation value of " + modOp);
            }
        }
    }

    public void groupModified(LdapDN name, ModificationItemImpl[] mods, Attributes entry) throws NamingException {
        Attribute members = null;
        String memberAttrId = null;
        Attribute oc = entry.get("objectClass");
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"groupOfNames") || AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"2.5.6.9")) {
            members = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.memberAT);
            memberAttrId = "member";
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"groupOfUniqueNames") || AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"2.5.6.17")) {
            members = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.uniqueMemberAT);
            memberAttrId = "uniqueMember";
        }
        if (members == null) {
            return;
        }
        for (ModificationItemImpl modification : mods) {
            if (!memberAttrId.equalsIgnoreCase(modification.getAttribute().getID())) continue;
            Set<String> memberSet = this.groups.get(name.getNormName());
            if (memberSet == null) break;
            this.modify(memberSet, modification.getModificationOp(), modification.getAttribute());
            break;
        }
        if (IS_DEBUG) {
            log.debug("group cache contents after modifying '{}' :\n {}", (Object)name.getUpName(), this.groups);
        }
    }

    public void groupModified(LdapDN name, int modOp, Attributes mods, Attributes entry) throws NamingException {
        Attribute members = this.getMemberAttribute(mods);
        if (members == null) {
            return;
        }
        Set<String> memberSet = this.groups.get(name.getNormName());
        if (memberSet != null) {
            this.modify(memberSet, modOp, members);
        }
        if (IS_DEBUG) {
            log.debug("group cache contents after modifying '{}' :\n {}", (Object)name.getUpName(), this.groups);
        }
    }

    public final boolean isPrincipalAnAdministrator(LdapDN principalDn) {
        if (principalDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
            return true;
        }
        Set<String> members = this.groups.get(this.administratorsGroupDn.getNormName());
        if (members == null) {
            log.warn("What do you mean there is no administrators group? This is bad news.");
            return false;
        }
        return members.contains(principalDn.toNormName());
    }

    public Set<LdapDN> getGroups(String member) throws NamingException {
        LdapDN normMember = null;
        try {
            normMember = this.parseNormalized(member);
        }
        catch (NamingException e) {
            log.warn("Malformed member DN.  Could not find groups for member '{}' in GroupCache. Returning empty set for groups!", (Object)member, (Object)e);
            return EMPTY_GROUPS;
        }
        HashSet<LdapDN> memberGroups = null;
        for (String group : this.groups.keySet()) {
            Set<String> members = this.groups.get(group);
            if (members == null || !members.contains(normMember.getNormName())) continue;
            if (memberGroups == null) {
                memberGroups = new HashSet<LdapDN>();
            }
            memberGroups.add(this.parseNormalized(group));
        }
        if (memberGroups == null) {
            return EMPTY_GROUPS;
        }
        return memberGroups;
    }

    public boolean groupRenamed(LdapDN oldName, LdapDN newName) {
        Set<String> members = this.groups.remove(oldName.getNormName());
        if (members != null) {
            this.groups.put(newName.getNormName(), members);
            if (IS_DEBUG) {
                log.debug("group cache contents after renaming '{}' :\n{}", (Object)oldName.getUpName(), this.groups);
            }
            return true;
        }
        return false;
    }
}

