/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDirectoryReader;

public class ZipReader
extends AbstractDocumentReader {
    private final ZipInputStream in;
    private DocumentReader delegate;

    public ZipReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public ZipReader(InputStream in) throws IOException {
        this.in = new ZipInputStream(in);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws IOException {
        ZipEntry entry = this.in.getNextEntry();
        if (NuxeoArchiveReader.isMarkerEntry(entry)) {
            this.delegate = new NuxeoArchiveReader(this.in, false);
        } else {
            File root = null;
            try {
                root = File.createTempFile("nuxeo-import-", ".unzip");
                root.delete();
                root.mkdirs();
                ZipReader.extract(this.in, entry, root);
                while ((entry = this.in.getNextEntry()) != null) {
                    ZipReader.extract(this.in, entry, root);
                }
            }
            finally {
                this.in.close();
            }
            this.delegate = new XMLDirectoryReader(root);
        }
    }

    @Override
    public ExportedDocument read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(ZipInputStream in, ZipEntry entry, File root) throws IOException {
        if (!entry.isDirectory()) {
            File file = new File(root, entry.getName());
            if (!file.getParentFile().mkdirs()) {
                throw new IOException("Failed to create directory: " + file.getParent());
            }
            FileOutputStream out = new FileOutputStream(file);
            try {
                FileUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
    }
}

