/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.IOException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelReader;

public class DocumentChildrenReader
extends DocumentModelReader {
    private DocumentModelIterator iterator;

    public DocumentChildrenReader(CoreSession session, DocumentModel root) throws ClientException {
        super(session);
        this.iterator = session.getChildrenIterator(root.getRef());
    }

    public DocumentChildrenReader(CoreSession session, DocumentRef root) throws ClientException {
        this(session, session.getDocument(root));
    }

    @Override
    public void close() {
        super.close();
        this.iterator = null;
    }

    @Override
    public ExportedDocument read() throws IOException {
        if (this.iterator.hasNext()) {
            DocumentModel docModel = (DocumentModel)this.iterator.next();
            return new ExportedDocumentImpl(docModel);
        }
        return null;
    }
}

