/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentWriter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.JavaTypes;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.ByteArraySource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public abstract class AbstractDocumentModelWriter
extends AbstractDocumentWriter {
    private static final Log log = LogFactory.getLog(AbstractDocumentModelWriter.class);
    protected CoreSession session;
    protected Path root;
    private int saveInterval;
    protected int unsavedDocuments = 0;
    private final Map<DocumentLocation, DocumentLocation> translationMap = new HashMap<DocumentLocation, DocumentLocation>();

    protected AbstractDocumentModelWriter(CoreSession session, String parentPath) {
        this(session, parentPath, 10);
    }

    protected AbstractDocumentModelWriter(CoreSession session, String parentPath, int saveInterval) {
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        this.session = session;
        this.saveInterval = saveInterval;
        this.root = new Path(parentPath);
    }

    public Map<DocumentLocation, DocumentLocation> getTranslationMap() {
        return this.translationMap;
    }

    protected void saveIfNeeded() throws ClientException {
        if (this.unsavedDocuments >= this.saveInterval) {
            this.session.save();
            this.unsavedDocuments = 0;
        }
    }

    @Override
    public void close() {
        if (this.unsavedDocuments > 0) {
            try {
                this.session.save();
            }
            catch (ClientException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        this.session = null;
        this.root = null;
    }

    protected DocumentModel createDocument(ExportedDocument xdoc, Path toPath) throws ClientException {
        Path parentPath = toPath.removeLastSegments(1);
        String name = toPath.lastSegment();
        DocumentModelImpl doc = new DocumentModelImpl(parentPath.toString(), name, xdoc.getType());
        Element system = xdoc.getDocument().getRootElement().element("system");
        String lifeCycleState = system.element("lifecycle-state").getText();
        doc.putContextData("initialLifecycleState", (Serializable)((Object)lifeCycleState));
        this.loadSchemas(xdoc, (DocumentModel)doc, xdoc.getDocument());
        if (doc.hasSchema("uid")) {
            doc.putContextData(ScopeType.REQUEST, "SKIP_VERSIONING", (Serializable)Boolean.valueOf(true));
        }
        doc = this.session.createDocument((DocumentModel)doc);
        this.loadSystemInfo((DocumentModel)doc, xdoc.getDocument());
        ++this.unsavedDocuments;
        this.saveIfNeeded();
        return doc;
    }

    protected DocumentModel updateDocument(ExportedDocument xdoc, DocumentModel doc) throws ClientException {
        this.loadSchemas(xdoc, doc, xdoc.getDocument());
        doc = this.session.saveDocument(doc);
        ++this.unsavedDocuments;
        this.saveIfNeeded();
        return doc;
    }

    public int getSaveInterval() {
        return this.saveInterval;
    }

    public void setSaveInterval(int saveInterval) {
        this.saveInterval = saveInterval;
    }

    protected void loadSystemInfo(DocumentModel docModel, Document doc) throws ClientException {
        Element system = doc.getRootElement().element("system");
        Element accessControl = system.element("access-control");
        if (accessControl == null) {
            return;
        }
        Iterator it = accessControl.elementIterator("acl");
        while (it.hasNext()) {
            List entries;
            int size;
            Element element = (Element)it.next();
            if (!"local".equals(element.attributeValue("name")) || (size = (entries = element.elements()).size()) <= 0) continue;
            ACPImpl acp = new ACPImpl();
            ACLImpl acl = new ACLImpl("local");
            acp.addACL((ACL)acl);
            for (int i = 0; i < size; ++i) {
                Element el = (Element)entries.get(i);
                String username = el.attributeValue("principal");
                String permission = el.attributeValue("permission");
                String grant = el.attributeValue("grant");
                ACE ace = new ACE(username, permission, Boolean.parseBoolean(grant));
                acl.add((Object)ace);
            }
            acp.addACL((ACL)acl);
            this.session.setACP(docModel.getRef(), (ACP)acp, false);
        }
    }

    protected void loadSchemas(ExportedDocument xdoc, DocumentModel docModel, Document doc) throws ClientException {
        SchemaManager schemaMgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Iterator it = doc.getRootElement().elementIterator("schema");
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String schemaName = element.attributeValue("name");
            Schema schema = schemaMgr.getSchema(schemaName);
            if (schema == null) {
                throw new ClientException("Schema not found: " + schemaName);
            }
            AbstractDocumentModelWriter.loadSchema(xdoc, schema, docModel, element);
        }
    }

    protected static void loadSchema(ExportedDocument xdoc, Schema schema, DocumentModel doc, Element schemaElement) throws ClientException {
        String schemaName = schemaElement.attributeValue("name");
        HashMap<String, Object> data = new HashMap<String, Object>();
        Iterator it = schemaElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String name = element.getName();
            Field field = schema.getField(name);
            if (field == null) {
                throw new ClientException("Invalid input document. No such property was found " + name + " in schema " + schemaName);
            }
            Object value = AbstractDocumentModelWriter.getElementData(xdoc, element, field.getType());
            data.put(name, value);
        }
        doc.setProperties(schemaName, data);
    }

    private static Object getElementData(ExportedDocument xdoc, Element element, Type type) {
        if (type.isSimpleType()) {
            return type.decode(element.getText());
        }
        if (type.isListType()) {
            ListType ltype = (ListType)type;
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator it = element.elementIterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                list.add(AbstractDocumentModelWriter.getElementData(xdoc, el, ltype.getFieldType()));
            }
            Type ftype = ltype.getFieldType();
            if (ftype.isSimpleType()) {
                Class klass = JavaTypes.getClass((Type)ftype);
                if (klass.isPrimitive()) {
                    return PrimitiveArrays.toPrimitiveArray(list, (Class)klass);
                }
                return list.toArray((Object[])Array.newInstance(klass, list.size()));
            }
            return list;
        }
        ComplexType ctype = (ComplexType)type;
        if (TypeConstants.isContentType((Type)ctype)) {
            String mimeType = element.elementText("mime-type");
            String encoding = element.elementText("encoding");
            String content = element.elementTextTrim("data");
            String filename = element.elementTextTrim("filename");
            if (!(content != null && content.length() != 0 || mimeType != null && mimeType.length() != 0)) {
                return null;
            }
            Blob blob = null;
            if (xdoc.hasExternalBlobs()) {
                blob = xdoc.getBlob(content);
            }
            if (blob == null) {
                byte[] bytes = Base64.decode((String)content);
                blob = new StreamingBlob((StreamSource)new ByteArraySource(bytes));
            }
            blob.setMimeType(mimeType);
            blob.setEncoding(encoding);
            blob.setFilename(filename);
            return blob;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String name = el.getName();
            Object value = AbstractDocumentModelWriter.getElementData(xdoc, el, ctype.getField(el.getName()).getType());
            map.put(name, value);
        }
        return map;
    }
}

