/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.lang.UpdateParser;
import com.hp.hpl.jena.sparql.lang.arq.ARQParser;
import com.hp.hpl.jena.sparql.lang.arq.ParseException;
import com.hp.hpl.jena.sparql.lang.arq.TokenMgrError;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.logging.Log;
import org.slf4j.LoggerFactory;

public class ParserARQUpdate
extends UpdateParser {
    protected UpdateRequest parse$(UpdateRequest update2, String queryString) {
        StringReader r = new StringReader(queryString);
        return this._parse(update2, r);
    }

    protected UpdateRequest parse$(UpdateRequest update2, PeekReader pr) {
        return this._parse(update2, pr);
    }

    public UpdateRequest parse(UpdateRequest update2, Reader r) {
        if (r instanceof FileReader) {
            LoggerFactory.getLogger(this.getClass()).warn("FileReader passed to ParserSPARQLUpdate.parse - use a FileInputStream");
        }
        return this._parse(update2, r);
    }

    private UpdateRequest _parse(UpdateRequest update2, Reader r) {
        ARQParser parser = null;
        try {
            parser = new ARQParser(r);
            parser.setUpdateRequest(update2);
            parser.UpdateUnit();
            this.validateParsedUpdate(update2);
            return update2;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            Log.fatal(this, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

