/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.security.guards;

import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.security.Guard;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Adaptable;

@XObject(value="script")
public class ScriptGuard
implements Guard {
    private static final Log log = LogFactory.getLog(ScriptGuard.class);
    @XContent
    protected String script;
    @XNode(value="@type")
    protected String type;
    @XNode(value="@src")
    protected String src;
    protected ScriptEngine engine;
    protected CompiledScript comp;

    protected ScriptGuard() {
    }

    public ScriptGuard(String type, String script) {
        this.type = type;
        this.script = script;
    }

    @Override
    public boolean check(Adaptable context) {
        try {
            if (this.engine == null) {
                this.comp = this.compile(this.type, this.script);
            }
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("Context", (Object)context);
            bindings.put("doc", context.getAdapter(DocumentModel.class));
            bindings.put("session", context.getAdapter(CoreSession.class));
            bindings.put("principal", context.getAdapter(Principal.class));
            Object result = null;
            if (this.comp != null) {
                result = this.comp.eval(bindings);
                if (result == null) {
                    result = bindings.get("__result__");
                }
            } else {
                result = this.engine.eval((Reader)new StringReader(this.script), (Bindings)bindings);
            }
            return ScriptGuard.booleanValue(result);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected static boolean booleanValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == Boolean.class) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        return false;
    }

    public String toString() {
        return "SCRIPT:" + this.type + '[' + this.script + ']';
    }

    private CompiledScript compile(String type, String content) throws ScriptException {
        if (this.engine == null) {
            this.engine = ((WebEngine)Framework.getLocalService(WebEngine.class)).getScripting().getEngineManager().getEngineByName(type);
        }
        if (this.engine != null) {
            if (this.engine instanceof Compilable) {
                return ((Compilable)((Object)this.engine)).compile(content);
            }
            return null;
        }
        throw new ScriptException("No suitable script engine found for the file " + type);
    }
}

