/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile;

import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class UserProfileServiceImpl
extends DefaultComponent
implements UserProfileService {
    private UserWorkspaceService userWorkspaceService;

    @Override
    public DocumentModel getUserProfileDocument(CoreSession session) throws ClientException {
        DocumentModel userWorkspace = this.getUserWorkspaceService().getCurrentUserPersonalWorkspace(session, null);
        return new UserProfileDocumentGetter(session, userWorkspace).getOrCreate();
    }

    @Override
    public DocumentModel getUserProfileDocument(String userName, CoreSession session) throws ClientException {
        DocumentModel userWorkspace = this.getUserWorkspaceService().getUserPersonalWorkspace(userName, session.getRootDocument());
        return new UserProfileDocumentGetter(session, userWorkspace).getOrCreate();
    }

    @Override
    public DocumentModel getUserProfile(DocumentModel userModel, CoreSession session) throws ClientException {
        DocumentModel userProfileDoc = this.getUserProfileDocument(userModel.getId(), session);
        ((DocumentModelImpl)userProfileDoc).detach(true);
        userProfileDoc.getDataModels().putAll((Map)userModel.getDataModels());
        return userProfileDoc;
    }

    private UserWorkspaceService getUserWorkspaceService() {
        if (this.userWorkspaceService == null) {
            this.userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        }
        return this.userWorkspaceService;
    }

    private class UserProfileDocumentGetter
    extends UnrestrictedSessionRunner {
        private DocumentModel userWorkspace;
        private DocumentRef userProfileDocRef;

        public UserProfileDocumentGetter(CoreSession session, DocumentModel userWorkspace) {
            super(session);
            this.userWorkspace = userWorkspace;
        }

        public void run() throws ClientException {
            DocumentModelList children = this.session.getChildren(this.userWorkspace.getRef(), "UserProfile");
            if (!children.isEmpty()) {
                this.userProfileDocRef = ((DocumentModel)children.get(0)).getRef();
            } else {
                DocumentModel userProfileDoc = this.session.createDocumentModel(this.userWorkspace.getPathAsString(), String.valueOf(System.currentTimeMillis()), "UserProfile");
                userProfileDoc = this.session.createDocument(userProfileDoc);
                this.userProfileDocRef = userProfileDoc.getRef();
                ACP acp = this.session.getACP(this.userProfileDocRef);
                ACL acl = acp.getOrCreateACL();
                acl.add((Object)new ACE("Everyone", "Read", true));
                acp.addACL(acl);
                this.session.setACP(this.userProfileDocRef, acp, true);
                this.session.save();
            }
        }

        public DocumentModel getOrCreate() throws ClientException {
            if (this.session.hasPermission(this.userWorkspace.getRef(), "AddChildren")) {
                this.run();
            } else {
                this.runUnrestricted();
            }
            return this.session.getDocument(this.userProfileDocRef);
        }
    }
}

