/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets.plugins;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.CompositeFaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributes;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.ui.DecorateHandler;
import com.sun.facelets.tag.ui.ParamHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.TagConfigFactory;
import org.nuxeo.ecm.platform.forms.layout.facelets.ValueExpressionHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.plugins.AbstractWidgetTypeHandler;

public class TemplateWidgetTypeHandler
extends AbstractWidgetTypeHandler {
    private static final Log log = LogFactory.getLog(TemplateWidgetTypeHandler.class);
    private static final long serialVersionUID = 6886289896957398368L;
    public static final String TEMPLATE_PROPERTY_NAME = "template";

    @Override
    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers) throws WidgetException {
        String template = this.getTemplateValue(widget);
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        if (template == null) {
            log.error((Object)("Missing template property for widget " + widget.getName() + " in layout " + widget.getLayoutName()));
            return leaf;
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, tagConfig);
        String widgetId = widget.getId();
        TagAttributes attributes = helper.getTagAttributes(widgetId, widget);
        TagAttribute templateAttr = this.getTemplateAttribute(helper);
        if (templateAttr == null) {
            templateAttr = helper.createAttribute(TEMPLATE_PROPERTY_NAME, template);
        }
        attributes = FaceletHandlerHelper.addTagAttribute(attributes, templateAttr);
        String widgetTagConfigId = widget.getTagConfigId();
        TagConfig config = TagConfigFactory.createTagConfig(tagConfig, widgetTagConfigId, attributes, this.getNextHandler(ctx, tagConfig, helper, widget, widgetTagConfigId));
        return new DecorateHandler(config);
    }

    protected FaceletHandler getNextHandler(FaceletContext ctx, TagConfig tagConfig, FaceletHandlerHelper helper, Widget widget, String widgetTagConfigId) throws WidgetException {
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        FieldDefinition[] fieldDefs = widget.getFieldDefinitions();
        if (fieldDefs == null) {
            return leaf;
        }
        ArrayList<ParamHandler> paramHandlers = new ArrayList<ParamHandler>();
        for (int i = 0; i < fieldDefs.length; ++i) {
            if (i == 0) {
                paramHandlers.add(this.getFieldParamHandler(ctx, tagConfig, helper, leaf, widget, widgetTagConfigId, fieldDefs[i], null));
            }
            paramHandlers.add(this.getFieldParamHandler(ctx, tagConfig, helper, leaf, widget, widgetTagConfigId, fieldDefs[i], i));
        }
        for (Map.Entry prop : widget.getProperties().entrySet()) {
            String key = (String)prop.getKey();
            TagAttribute name = helper.createAttribute("name", String.format("%s_%s", RenderVariables.widgetVariables.widgetProperty.name(), key));
            Serializable valueInstance = (Serializable)prop.getValue();
            TagAttribute value = !helper.shouldCreateReferenceAttribute(key, valueInstance) ? helper.createAttribute("value", (String)((Object)valueInstance)) : helper.createAttribute("value", String.format("#{%s.properties.%s}", RenderVariables.widgetVariables.widget.name(), key));
            TagConfig config = TagConfigFactory.createTagConfig(tagConfig, widgetTagConfigId, FaceletHandlerHelper.getTagAttributes(name, value), leaf);
            paramHandlers.add(new ParamHandler(config));
        }
        return new CompositeFaceletHandler((FaceletHandler[])paramHandlers.toArray(new ParamHandler[0]));
    }

    protected ParamHandler getFieldParamHandler(FaceletContext ctx, TagConfig tagConfig, FaceletHandlerHelper helper, FaceletHandler leaf, Widget widget, String widgetTagConfigId, FieldDefinition fieldDef, Integer index) {
        String computedName = index == null ? String.format("%s", RenderVariables.widgetVariables.field.name()) : String.format("%s_%s", RenderVariables.widgetVariables.field.name(), index);
        TagAttribute name = helper.createAttribute("name", computedName);
        String computedValue = ValueExpressionHelper.createExpressionString(widget.getValueName(), fieldDef);
        TagAttribute value = helper.createAttribute("value", computedValue);
        TagConfig config = TagConfigFactory.createTagConfig(tagConfig, widgetTagConfigId, FaceletHandlerHelper.getTagAttributes(name, value), leaf);
        return new ParamHandler(config);
    }

    protected String getTemplateValue(Widget widget) {
        String template = this.getProperty(TEMPLATE_PROPERTY_NAME);
        if (template == null) {
            template = (String)((Object)widget.getProperty(TEMPLATE_PROPERTY_NAME));
        }
        return template;
    }

    protected TagAttribute getTemplateAttribute(FaceletHandlerHelper helper) {
        return null;
    }
}

