/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.CompositeFaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributes;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.LayoutTagHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.TagConfigFactory;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class DocumentLayoutTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(DocumentLayoutTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute mode;
    protected final TagAttribute documentMode;
    protected final TagAttribute value;
    protected final TagAttribute template;
    protected final TagAttribute defaultLayout;
    protected final TagAttribute includeAnyMode;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "name", "mode", "documentMode", "value", "template", "defaultLayout", "includeAnyMode"};

    public DocumentLayoutTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.mode = this.getRequiredAttribute("mode");
        this.documentMode = this.getAttribute("documentMode");
        this.value = this.getRequiredAttribute("value");
        this.template = this.getAttribute("template");
        this.defaultLayout = this.getAttribute("defaultLayout");
        this.includeAnyMode = this.getAttribute("includeAnyMode");
        this.vars = this.tag.getAttributes().getAll();
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        String[] layoutNames;
        Object document = this.value.getObject(ctx, DocumentModel.class);
        if (!(document instanceof DocumentModel)) {
            return;
        }
        TypeInfo typeInfo = (TypeInfo)((DocumentModel)document).getAdapter(TypeInfo.class);
        if (typeInfo == null) {
            return;
        }
        String modeValue = this.mode.getValue(ctx);
        String documentModeValue = null;
        if (this.documentMode != null) {
            documentModeValue = this.documentMode.getValue(ctx);
        }
        boolean useAnyMode = true;
        if (this.includeAnyMode != null) {
            useAnyMode = this.includeAnyMode.getBoolean(ctx);
        }
        if ((layoutNames = typeInfo.getLayouts(documentModeValue == null ? modeValue : documentModeValue, useAnyMode ? "any" : null)) == null || layoutNames.length == 0) {
            if (this.defaultLayout != null) {
                layoutNames = new String[]{this.defaultLayout.getValue()};
            } else {
                return;
            }
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        TagAttribute modeAttr = helper.createAttribute("mode", modeValue);
        ArrayList<LayoutTagHandler> handlers = new ArrayList<LayoutTagHandler>();
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        for (String layoutName : layoutNames) {
            TagAttributes attributes = FaceletHandlerHelper.getTagAttributes(helper.createAttribute("name", layoutName), modeAttr, this.value);
            if (this.template != null) {
                attributes = FaceletHandlerHelper.addTagAttribute(attributes, this.template);
            }
            List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
            for (TagAttribute var : this.vars) {
                String localName = var.getLocalName();
                if (reservedVars.contains(localName)) continue;
                attributes = FaceletHandlerHelper.addTagAttribute(attributes, var);
            }
            TagConfig tagConfig = TagConfigFactory.createTagConfig(this.config, null, attributes, leaf);
            handlers.add(new LayoutTagHandler(tagConfig));
        }
        CompositeFaceletHandler composite = new CompositeFaceletHandler(handlers.toArray(new FaceletHandler[0]));
        composite.apply(ctx, parent);
    }
}

