/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.betwixt.registry.PolymorphicReferenceResolver;
import org.apache.commons.betwixt.registry.XMLBeanInfoRegistry;

public class DefaultXMLBeanInfoRegistry
implements XMLBeanInfoRegistry,
PolymorphicReferenceResolver {
    private Map xmlBeanInfos = new HashMap();

    public XMLBeanInfo get(Class forThisClass) {
        return (XMLBeanInfo)this.xmlBeanInfos.get(forThisClass);
    }

    public void put(Class forThisClass, XMLBeanInfo beanInfo) {
        this.xmlBeanInfos.put(forThisClass, beanInfo);
    }

    public void flush() {
        this.xmlBeanInfos.clear();
    }

    public Class resolveType(ElementMapping mapping, ReadContext context) {
        Class result = null;
        Collection cachedClasses = this.getCachedClasses();
        ElementDescriptor mappedDescriptor = mapping.getDescriptor();
        Class mappedType = mappedDescriptor.getSingularPropertyType();
        if (mappedType == null) {
            mappedType = mappedDescriptor.getPropertyType();
        }
        Iterator it = cachedClasses.iterator();
        while (it.hasNext()) {
            boolean compatibleClass;
            XMLBeanInfo beanInfo = this.get((Class)it.next());
            ElementDescriptor typeDescriptor = beanInfo.getElementDescriptor();
            boolean sameName = mapping.getName().equals(typeDescriptor.getQualifiedName());
            if (!sameName || !(compatibleClass = mappedType.isAssignableFrom(beanInfo.getBeanClass()))) continue;
            result = beanInfo.getBeanClass();
            break;
        }
        return result;
    }

    private Collection getCachedClasses() {
        return this.xmlBeanInfos.keySet();
    }
}

