/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.convert.Converter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.security.UserDisplayConverter;

@Name(value="userSuggestionActions")
@Scope(value=ScopeType.PAGE)
public class UserSuggestionActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserSuggestionActionsBean.class);
    public static final String USER_TYPE = "USER_TYPE";
    public static final String GROUP_TYPE = "GROUP_TYPE";
    public static final String TYPE_KEY_NAME = "type";
    public static final String PREFIXED_ID_KEY_NAME = "prefixed_id";
    public static final String ID_KEY_NAME = "id";
    public static final String ENTRY_KEY_NAME = "entry";
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @RequestParameter
    protected String userSuggestionSearchType;
    protected String cachedUserSuggestionSearchType;
    @RequestParameter
    protected Integer userSuggestionMaxSearchResults;
    @RequestParameter
    protected Boolean hideVirtualGroups;
    protected Integer cachedUserSuggestionMaxSearchResults;
    protected Object cachedInput;
    protected Object cachedSuggestions;
    @RequestParameter
    protected String userSuggestionMessageId;
    @RequestParameter
    protected String suggestionSelectionListId;

    protected void addSearchOverflowMessage() {
        if (this.userSuggestionMessageId != null) {
            this.facesMessages.addToControl(this.userSuggestionMessageId, StatusMessage.Severity.ERROR, this.resourcesAccessor.getMessages().get("label.security.searchOverFlow"), new Object[0]);
        } else {
            log.error((Object)"Search overflow");
        }
    }

    public List<DocumentModel> getGroupsSuggestions(Object input) throws ClientException {
        try {
            HashMap<String, DocumentModel> uniqueGroups = new HashMap<String, DocumentModel>();
            String pattern = (String)input;
            for (String field : this.userManager.getGroupSearchFields()) {
                HashMap<String, Object> filter = new HashMap<String, Object>();
                if (pattern != null && pattern != "") {
                    filter.put(field, pattern);
                }
                if (Boolean.TRUE.equals(this.hideVirtualGroups)) {
                    filter.put("__virtualGroup", false);
                }
                for (DocumentModel group : this.userManager.searchGroups(filter, filter.keySet())) {
                    uniqueGroups.put(group.getId(), group);
                }
            }
            DocumentModelListImpl groups = new DocumentModelListImpl();
            groups.addAll(uniqueGroups.values());
            Collections.sort(groups, new DocumentModelComparator(this.userManager.getGroupSchemaName(), this.getGroupsOrderBy()));
            return groups;
        }
        catch (SizeLimitExceededException e) {
            this.addSearchOverflowMessage();
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new ClientException("error searching for groups", (Throwable)e);
        }
    }

    protected Map<String, String> getGroupsOrderBy() throws ClientException {
        HashMap<String, String> order = new HashMap<String, String>();
        order.put(this.userManager.getGroupLabelField(), "asc");
        return order;
    }

    public List<DocumentModel> getUserSuggestions(Object input) throws ClientException {
        try {
            String searchPattern = (String)input;
            return this.userManager.searchUsers(searchPattern);
        }
        catch (SizeLimitExceededException e) {
            this.addSearchOverflowMessage();
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new ClientException("error searching for principals", (Throwable)e);
        }
    }

    protected boolean equals(Object item1, Object item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null) {
            return false;
        }
        return item1.equals(item2);
    }

    public Object getSuggestions(Object input) throws ClientException {
        HashMap<String, String> entry;
        if (this.equals(this.cachedUserSuggestionSearchType, this.userSuggestionSearchType) && this.equals(this.cachedUserSuggestionMaxSearchResults, this.userSuggestionMaxSearchResults) && this.equals(this.cachedInput, input)) {
            return this.cachedSuggestions;
        }
        List<Object> users = Collections.emptyList();
        if (USER_TYPE.equals(this.userSuggestionSearchType) || StringUtils.isEmpty((String)this.userSuggestionSearchType)) {
            users = this.getUserSuggestions(input);
        }
        List<Object> groups = Collections.emptyList();
        if (GROUP_TYPE.equals(this.userSuggestionSearchType) || StringUtils.isEmpty((String)this.userSuggestionSearchType)) {
            groups = this.getGroupsSuggestions(input);
        }
        int userSize = users.size();
        int groupSize = groups.size();
        int totalSize = userSize + groupSize;
        if (this.userSuggestionMaxSearchResults != null && this.userSuggestionMaxSearchResults > 0 && (userSize > this.userSuggestionMaxSearchResults || groupSize > this.userSuggestionMaxSearchResults || totalSize > this.userSuggestionMaxSearchResults)) {
            this.addSearchOverflowMessage();
            return null;
        }
        ArrayList result = new ArrayList(totalSize);
        for (DocumentModel documentModel : users) {
            entry = new HashMap<String, String>();
            entry.put(TYPE_KEY_NAME, USER_TYPE);
            entry.put(ENTRY_KEY_NAME, (String)documentModel);
            String userId = documentModel.getId();
            entry.put(ID_KEY_NAME, userId);
            entry.put(PREFIXED_ID_KEY_NAME, "user:" + userId);
            result.add(entry);
        }
        for (DocumentModel documentModel : groups) {
            entry = new HashMap();
            entry.put(TYPE_KEY_NAME, GROUP_TYPE);
            entry.put(ENTRY_KEY_NAME, (String)documentModel);
            String groupId = documentModel.getId();
            entry.put(ID_KEY_NAME, groupId);
            entry.put(PREFIXED_ID_KEY_NAME, "group:" + groupId);
            result.add(entry);
        }
        this.cachedInput = input;
        this.cachedUserSuggestionSearchType = this.userSuggestionSearchType;
        this.cachedUserSuggestionMaxSearchResults = this.userSuggestionMaxSearchResults;
        this.cachedSuggestions = result;
        return result;
    }

    public Map<String, Object> getPrefixedUserInfo(String id) throws ClientException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put(PREFIXED_ID_KEY_NAME, id);
        if (!StringUtils.isBlank((String)id)) {
            if (id.startsWith("user:")) {
                res.put(TYPE_KEY_NAME, USER_TYPE);
                String username = id.substring("user:".length());
                res.put(ID_KEY_NAME, username);
                res.put(ENTRY_KEY_NAME, this.userManager.getUserModel(username));
            } else if (id.startsWith("group:")) {
                res.put(TYPE_KEY_NAME, GROUP_TYPE);
                String groupname = id.substring("group:".length());
                res.put(ID_KEY_NAME, groupname);
                res.put(ENTRY_KEY_NAME, this.userManager.getGroupModel(groupname));
            } else {
                res.put(ID_KEY_NAME, id);
            }
        }
        return res;
    }

    public Map<String, Object> getUserInfo(String id) throws ClientException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put(ID_KEY_NAME, id);
        if (this.userManager.getGroup(id) != null) {
            res.put(PREFIXED_ID_KEY_NAME, "group:" + id);
            res.put(TYPE_KEY_NAME, GROUP_TYPE);
            res.put(ENTRY_KEY_NAME, this.userManager.getGroupModel(id));
        } else if (!StringUtils.isBlank((String)id)) {
            res.put(PREFIXED_ID_KEY_NAME, "user:" + id);
            res.put(TYPE_KEY_NAME, USER_TYPE);
            res.put(ENTRY_KEY_NAME, this.userManager.getUserModel(id));
        }
        return res;
    }

    public Converter getUserConverter() {
        return new UserDisplayConverter();
    }
}

