/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.StringTokenizer;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webapp.seam.NuxeoSeamWebGate;
import org.nuxeo.ecm.webapp.seam.SeamHotReloadHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;

public class NuxeoSeamFlusher
implements EventListener {
    protected Log log = LogFactory.getLog(NuxeoSeamFlusher.class);

    public boolean aboutToHandleEvent(Event event) {
        return true;
    }

    public void handleEvent(Event event) {
        if (!NuxeoSeamWebGate.isInitialized()) {
            return;
        }
        String id = event.getId();
        if ("flush".equals(id) || "flushSeamComponents".equals(id)) {
            SeamHotReloadHelper.flush();
            try {
                this.invalidateWebSessions();
            }
            catch (Exception e) {
                this.log.error((Object)"Cannot invalidate seam web sessions", (Throwable)e);
            }
        } else if ("reload".equals(id) || "reloadSeamComponents".equals(id)) {
            try {
                if (!this.postSeamReload()) {
                    this.log.error((Object)"Cannot post hot-reload seam components on loopback url");
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Cannot hot-reload seam components", (Throwable)e);
            }
        }
    }

    protected boolean postSeamReload() throws IOException {
        String loopbackURL = Framework.getProperty((String)"nuxeo.loopback.url");
        URL location = new URL(loopbackURL + "/restAPI/seamReload");
        HttpURLConnection uc = (HttpURLConnection)location.openConnection();
        uc.setRequestMethod("POST");
        return uc.getResponseCode() == 200;
    }

    protected void invalidateWebSessions() throws IOException, MalformedObjectNameException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        for (ObjectInstance oi : mbs.queryMBeans(new ObjectName("Catalina:type=Manager,path=/nuxeo,host=*"), null)) {
            WebSessionFlusher flusher = JMX.newMBeanProxy(mbs, oi.getObjectName(), WebSessionFlusher.class);
            StringTokenizer tokenizer = new StringTokenizer(flusher.listSessionIds(), " ");
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken();
                flusher.expireSession(id);
            }
        }
    }

    @MXBean
    public static interface WebSessionFlusher {
        public String listSessionIds();

        public void expireSession(String var1);
    }
}

