/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.pagination;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.pagination.SortActions;

@Name(value="sortActions")
@Scope(value=ScopeType.CONVERSATION)
public class SortActionsBean
implements SortActions,
Serializable {
    private static final long serialVersionUID = 6824092797019313562L;
    private static final Log log = LogFactory.getLog(SortActionsBean.class);
    @RequestParameter(value="defaultSortAscending")
    protected Boolean defaultSortAscending = true;
    @RequestParameter(value="sortColumn")
    protected String newSortColumn = "dc:title";
    @In(required=false, create=true)
    protected transient ResultsProvidersCache resultsProvidersCache;
    @RequestParameter(value="invalidateSeamVariables")
    protected String invalidateSeamVariables;
    @RequestParameter(value="providerName")
    protected String providerName;

    @Override
    @Deprecated
    public void init() {
        log.debug((Object)"Initializing...");
    }

    @Override
    @Deprecated
    public void destroy() {
        log.debug((Object)"Destroy...");
    }

    protected boolean getDefaultSortOrder(String column) {
        if (this.defaultSortAscending != null) {
            return this.defaultSortAscending;
        }
        return true;
    }

    @Override
    public String repeatSearch() throws ClientException {
        SortInfo sortInfo;
        if (this.providerName == null) {
            throw new IllegalArgumentException("providerName is not set");
        }
        if (this.newSortColumn == null) {
            throw new IllegalArgumentException("newSortColumn is not set");
        }
        if (this.invalidateSeamVariables != null) {
            String[] variables;
            for (String variable : variables = this.invalidateSeamVariables.split(",")) {
                Contexts.removeFromAllContexts((String)variable);
            }
        }
        if ((sortInfo = this.resultsProvidersCache.get(this.providerName).getSortInfo()) == null) {
            sortInfo = new SortInfo(this.newSortColumn, this.getDefaultSortOrder(this.newSortColumn));
        } else {
            String sortColumn = sortInfo.getSortColumn();
            boolean sortAscending = sortInfo.getSortAscending();
            if (this.newSortColumn.equals(sortColumn)) {
                sortAscending = !sortAscending;
            } else {
                sortColumn = this.newSortColumn;
                sortAscending = this.getDefaultSortOrder(this.newSortColumn);
            }
            sortInfo = new SortInfo(sortColumn, sortAscending);
        }
        this.resultsProvidersCache.invalidate(this.providerName);
        this.resultsProvidersCache.get(this.providerName, sortInfo);
        return null;
    }
}

