/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.documentsLists;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.webapp.documentsLists.BaseDocumentsListsManager;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListDescriptor;

@Name(value="conversationDocumentsListsManager")
@Scope(value=ScopeType.CONVERSATION)
public class ConversationDocumentsListsManager
extends BaseDocumentsListsManager
implements Serializable {
    private static final long serialVersionUID = 9876098763432L;
    private Boolean initialized = false;
    private DocumentRef lastDocumentRef;

    @Override
    protected void notifyListUpdated(String listName) {
        Events.instance().raiseEvent(listName + "Updated", new Object[0]);
    }

    @Create
    public void initListManager() {
        if (!this.initialized.booleanValue()) {
            List<String> listContribNames = this.getService().getDocumentsListDescriptorsName();
            for (String listName : listContribNames) {
                DocumentsListDescriptor desc = this.getService().getDocumentsListDescriptor(listName);
                if (desc.getIsSession()) continue;
                this.createWorkingList(listName, desc);
            }
            this.initialized = true;
        }
    }

    @Observer(value={"folderishDocumentSelectionChanged"}, create=false)
    public void refreshLists(DocumentModel selectedDocument) {
        if (this.lastDocumentRef != null && this.lastDocumentRef.equals(selectedDocument.getRef())) {
            return;
        }
        if (!this.documentsLists_events.containsKey("folderishDocumentSelectionChanged")) {
            return;
        }
        for (String listName : (List)this.documentsLists_events.get("folderishDocumentSelectionChanged")) {
            List docList = (List)this.documentsLists.get(listName);
            if (docList.isEmpty()) continue;
            docList.clear();
            this.notifyListUpdated(listName);
        }
        this.lastDocumentRef = selectedDocument.getRef();
    }

    @Observer(value={"searchPerformed"}, create=false)
    public void refreshListsOnSearch() {
        if (!this.documentsLists_events.containsKey("searchPerformed")) {
            return;
        }
        for (String listName : (List)this.documentsLists_events.get("searchPerformed")) {
            List docList = (List)this.documentsLists.get(listName);
            if (docList.isEmpty()) continue;
            docList.clear();
            this.notifyListUpdated(listName);
        }
    }
}

