/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.dnd;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.platform.web.common.UserAgentMatcher;
import org.nuxeo.runtime.api.Framework;

@Name(value="dndConfigHelper")
@Scope(value=ScopeType.EVENT)
public class DndConfigurationHelper {
    public static final String DND_TIMEOUT_PROPERTY = "nuxeo.dnd.timeout";

    @Factory(value="useHtml5DragAndDrop", scope=ScopeType.SESSION)
    public boolean useHtml5DragAndDrop() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)econtext.getRequest();
        String ua = request.getHeader("User-Agent");
        return UserAgentMatcher.html5DndIsSupported((String)ua);
    }

    public void setHtml5DndEnabled(boolean enabled) {
        Contexts.getSessionContext().set("useHtml5DragAndDrop", (Object)enabled);
    }

    @Factory(value="dndTimeout", scope=ScopeType.SESSION)
    public int getDndTimeout() {
        try {
            return Integer.parseInt(Framework.getProperty((String)DND_TIMEOUT_PROPERTY));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

