/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DirectoryTreeService
extends DefaultComponent {
    public static final String NAME = DirectoryTreeService.class.getName();
    private static final Log log = LogFactory.getLog(DirectoryTreeService.class);
    protected Map<String, DirectoryTreeDescriptor> registry;

    public DirectoryTreeDescriptor getDirectoryTreeDescriptor(String treeName) {
        DirectoryTreeDescriptor desc = this.registry.get(treeName);
        if (desc.getEnabled().booleanValue()) {
            return desc;
        }
        return null;
    }

    public void activate(ComponentContext context) {
        this.registry = new HashMap<String, DirectoryTreeDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.registry = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        DirectoryTreeDescriptor descriptor = (DirectoryTreeDescriptor)contribution;
        if (this.registry.containsKey(descriptor.getName())) {
            DirectoryTreeDescriptor existing_descriptor = this.registry.get(descriptor.getName());
            existing_descriptor.merge(descriptor);
            log.debug((Object)("merged DirectoryTreeDescriptor: " + descriptor.getName()));
        } else {
            this.registry.put(descriptor.getName(), descriptor);
            log.debug((Object)("registered DirectoryTreeDescriptor: " + descriptor.getName()));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        DirectoryTreeDescriptor descriptor = (DirectoryTreeDescriptor)contribution;
        this.registry.remove(descriptor.getName());
        log.debug((Object)("unregistered DirectoryTreeDescriptor: " + descriptor.getName()));
    }

    public List<String> getDirectoryTrees() {
        ArrayList<String> directoryTrees = new ArrayList<String>();
        for (DirectoryTreeDescriptor desc : this.registry.values()) {
            if (!desc.getEnabled().booleanValue()) continue;
            directoryTrees.add(desc.getName());
        }
        Collections.sort(directoryTrees);
        return directoryTrees;
    }

    public List<String> getNavigationDirectoryTrees() {
        ArrayList<String> directoryTrees = new ArrayList<String>();
        for (DirectoryTreeDescriptor desc : this.registry.values()) {
            if (!desc.getEnabled().booleanValue() || !desc.isNavigationTree()) continue;
            directoryTrees.add(desc.getName());
        }
        Collections.sort(directoryTrees);
        return directoryTrees;
    }
}

